/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.UnsupportedEncodingException;

public class BytesEncodingChecker {
    public static final int BOM_0 = 254;
    public static final int BOM_1 = 255;
    public static final int UTF8_BOM_0 = 239;
    public static final int UTF8_BOM_1 = 187;
    public static final int UTF8_BOM_2 = 191;
    public static final int NUL = 0;
    private byte[] bytes;
    private boolean hasBOMPrefix;
    private boolean bomIsUTF16BE;
    private boolean bomIsUTF16LE;
    private boolean bomIsUTF8;
    private int bomPrefixSize;
    private boolean hasNULForUTF16BE;
    private boolean hasNULForUTF16LE;

    public BytesEncodingChecker(byte[] bytes) {
        this.bytes = bytes;
        this.hasBOMPrefix = false;
        this.bomIsUTF16BE = false;
        this.bomIsUTF16LE = false;
        this.bomIsUTF8 = false;
        this.bomPrefixSize = 0;
        this.hasNULForUTF16BE = false;
        this.hasNULForUTF16LE = false;
        if (2 <= bytes.length) {
            int b0 = bytes[0] & 0xFF;
            int b1 = bytes[1] & 0xFF;
            if (b0 == 254 && b1 == 255) {
                this.hasBOMPrefix = true;
                this.bomIsUTF16BE = true;
                this.bomPrefixSize = 2;
            } else if (b0 == 255 && b1 == 254) {
                this.hasBOMPrefix = true;
                this.bomIsUTF16LE = true;
                this.bomPrefixSize = 2;
            } else if (b0 == 0) {
                this.hasNULForUTF16BE = true;
            } else if (b1 == 0) {
                this.hasNULForUTF16LE = true;
            } else if (3 <= bytes.length) {
                int b2 = bytes[2] & 0xFF;
                if (b0 == 239 && b1 == 187 && b2 == 191) {
                    this.hasBOMPrefix = true;
                    this.bomIsUTF8 = true;
                    this.bomPrefixSize = 3;
                }
            }
        }
    }

    public boolean encodingIsKnown16Bit() {
        return this.hasBOMPrefix ? this.bomIsUTF16BE || this.bomIsUTF16LE : this.hasNULForUTF16BE || this.hasNULForUTF16LE;
    }

    public boolean utf16IsBE() {
        return this.hasBOMPrefix ? this.bomIsUTF16BE : this.hasNULForUTF16BE;
    }

    public boolean utf16IsLE() {
        return this.hasBOMPrefix ? this.bomIsUTF16LE : this.hasNULForUTF16LE;
    }

    public boolean encodingIsKnownUTF8() {
        return this.hasBOMPrefix && this.bomIsUTF8;
    }

    public String encodingForUCS16() {
        return this.bomIsUTF16BE || this.hasNULForUTF16BE ? "UTF-16BE" : (this.bomIsUTF16LE || this.hasNULForUTF16LE ? "UTF-16LE" : "????");
    }

    public int countBOMPrefixBytes() {
        return this.bomPrefixSize;
    }

    public String getDecodedString(String enc, int nskip) throws UnsupportedEncodingException {
        int BASE = nskip;
        int LENGTH = this.bytes.length - BASE;
        return new String(this.bytes, BASE, LENGTH, enc);
    }
}

