/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import util.ResourceUtils;

public final class AsciiIdMapper {
    private static AsciiIdMapper theAsciiMapper;
    private static final String ASCII_MAP_PATH = "util/mapISOToAscii.txt";
    private final int MAP_LIMIT = 256;
    private String[] isoMap = new String[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsciiIdMapper getAsciiIdMapper() {
        if (theAsciiMapper != null) return theAsciiMapper;
        Class<AsciiIdMapper> clazz = AsciiIdMapper.class;
        synchronized (AsciiIdMapper.class) {
            if (theAsciiMapper != null) return theAsciiMapper;
            theAsciiMapper = new AsciiIdMapper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theAsciiMapper;
        }
    }

    private AsciiIdMapper() {
        for (int i = 0; i != 256; ++i) {
            this.isoMap[i] = "";
        }
        Properties mapprops = ResourceUtils.getProperties(ASCII_MAP_PATH);
        Enumeration<?> mapkeys = mapprops.propertyNames();
        while (mapkeys.hasMoreElements()) {
            String keystr = (String)mapkeys.nextElement();
            String valstr = mapprops.getProperty(keystr).split("\\s+", 2)[0];
            this.insertMapEntry(keystr, valstr);
        }
    }

    public String toAscii(String id) {
        StringBuilder sb = new StringBuilder(2 * id.length());
        for (int i = 0; i != id.length(); ++i) {
            char ich = id.charAt(i);
            if (ich >= '\u0100') continue;
            sb.append(this.isoMap[ich]);
        }
        return sb.toString();
    }

    public String rawMactoAscii(String rawid) {
        byte[] bytes = AsciiIdMapper.string2Bytes(rawid);
        String encid = AsciiIdMapper.bytes2EncodedString(bytes, "MacRoman");
        return this.toAscii(encid);
    }

    private static byte[] string2Bytes(String str) {
        int N = str.length();
        byte[] bbuf = new byte[N + 1];
        for (int i = 0; i != N; ++i) {
            bbuf[i] = (byte)str.charAt(i);
        }
        bbuf[N] = 10;
        return bbuf;
    }

    private static String bytes2EncodedString(byte[] bytes, String enc) {
        String str = "_unknown_";
        ByteArrayInputStream bins = new ByteArrayInputStream(bytes);
        try {
            InputStreamReader rdr = new InputStreamReader((InputStream)bins, enc);
            BufferedReader brdr = new BufferedReader(rdr);
            str = brdr.readLine();
        }
        catch (IOException x) {
            // empty catch block
        }
        return str;
    }

    private void insertMapEntry(String keystr, String valstr) {
        try {
            int I = Integer.decode(keystr);
            String val = "";
            if (valstr.startsWith("0x")) {
                int ival = Integer.decode(valstr);
                if (0 <= ival && ival < 256) {
                    val = "" + (char)ival;
                }
            } else if (!valstr.equals("_")) {
                val = valstr;
            }
            this.isoMap[I] = val;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

