/*
 * Decompiled with CFR 0.152.
 */
package ssclient;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SiGMLUndoController {
    private static final String SUC_TAG = "ssclient.SiGMLUndoController";
    private static final String UNDO_REDO_KEYMAP = "SSC_UndoRedoKeymap";
    private static final int SIZE_DELTA = 256;
    private static final int UNDO_HISTORY_SIZE = 256;
    private static final boolean IS_MAC_OS_X = System.getProperty("os.name").toLowerCase().contains("mac os x");
    private static final int CMD_OR_CTRL_MASK;
    private static final int UNDO_MASK;
    private static final int REDO_MASK;
    private final JTextArea SIGML_TEXT_AREA;
    private final SiGMLUndoAction UNDO_ACTION;
    private final SiGMLRedoAction REDO_ACTION;
    private UndoManager undoMgr;
    private UndoableEditListener ueListener;
    private int ixEdit;
    private int ixEditLimit;
    private ArrayList<Integer> sigmlPos;
    private ArrayList<Integer> deltaLen;
    private ArrayList<Integer> deltaPos;
    private int len;
    private int pos;
    private int currDot;
    private int prevDot;

    public SiGMLUndoController(JTextArea tsigml) {
        this.SIGML_TEXT_AREA = tsigml;
        this.UNDO_ACTION = new SiGMLUndoAction();
        this.REDO_ACTION = new SiGMLRedoAction();
        this.undoMgr = null;
        this.ueListener = null;
        Keymap stdkeymap = this.SIGML_TEXT_AREA.getKeymap();
        Keymap urkeymap = JTextArea.addKeymap(UNDO_REDO_KEYMAP, stdkeymap);
        this.SIGML_TEXT_AREA.setKeymap(urkeymap);
        KeyStroke undoks = KeyStroke.getKeyStroke(90, UNDO_MASK);
        KeyStroke redoks = KeyStroke.getKeyStroke(90, REDO_MASK);
        urkeymap.addActionForKeyStroke(undoks, this.UNDO_ACTION);
        urkeymap.addActionForKeyStroke(redoks, this.REDO_ACTION);
        this.prevDot = -1;
        this.currDot = -1;
        this.SIGML_TEXT_AREA.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent cevt) {
                SiGMLUndoController.this.recordCaretChange(cevt.getDot(), cevt.getMark());
            }
        });
    }

    public boolean sigmlTextIsDirty() {
        return this.ueListener != null && this.ixEdit != 0;
    }

    public void setCleanSiGMLText() {
        if (this.sigmlTextIsDirty()) {
            this.endSupportForOldSiGML();
            this.beginSupportForNewSiGML();
        }
    }

    public void endSupportForOldSiGML() {
        if (this.undoMgr != null) {
            this.undoMgr.discardAllEdits();
            this.undoMgr = null;
        }
        if (this.ueListener != null) {
            this.SIGML_TEXT_AREA.getDocument().removeUndoableEditListener(this.ueListener);
            this.ueListener = null;
        }
        this.sigmlPos = null;
        this.deltaLen = null;
        this.deltaPos = null;
        this.prevDot = -1;
        this.currDot = -1;
    }

    public void beginSupportForNewSiGML() {
        this.sigmlPos = new ArrayList(256);
        this.deltaLen = new ArrayList(256);
        this.deltaPos = new ArrayList(256);
        this.ixEditLimit = 0;
        this.ixEdit = 0;
        this.prevDot = -1;
        this.currDot = this.SIGML_TEXT_AREA.getCaret().getDot();
        this.len = this.sigmlLength();
        this.pos = this.currDot;
        this.undoMgr = new UndoManager();
        this.undoMgr.setLimit(256);
        this.UNDO_ACTION.setEnabled(false);
        this.REDO_ACTION.setEnabled(false);
        this.ueListener = new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent eevt) {
                SiGMLUndoController.this.recordUndoableEdit(eevt.getEdit());
            }
        };
        this.SIGML_TEXT_AREA.getDocument().addUndoableEditListener(this.ueListener);
    }

    protected void recordCaretChange(int dot, int mark) {
        this.prevDot = this.currDot;
        this.currDot = dot;
    }

    protected int sigmlLength() {
        return this.SIGML_TEXT_AREA.getDocument().getLength();
    }

    protected void ensureListSizesOK() {
        if (this.ixEdit == this.sigmlPos.size()) {
            int NEW_SIZE = this.ixEdit + 256;
            this.sigmlPos.ensureCapacity(NEW_SIZE);
            this.deltaLen.ensureCapacity(NEW_SIZE);
            this.deltaPos.ensureCapacity(NEW_SIZE);
            for (int i = 0; i != 256; ++i) {
                this.sigmlPos.add(null);
                this.deltaLen.add(null);
                this.deltaPos.add(null);
            }
            if (this.ixEdit == this.undoMgr.getLimit()) {
                this.undoMgr.setLimit(NEW_SIZE);
            }
        }
    }

    protected void recordUndoableEdit(UndoableEdit uedit) {
        this.ensureListSizesOK();
        int IX = this.ixEdit++;
        this.ixEditLimit = this.ixEdit;
        int OLD_LEN = this.len;
        this.len = this.sigmlLength();
        int DELTA_LEN = this.len - OLD_LEN;
        this.deltaLen.set(IX, DELTA_LEN);
        this.pos = this.currDot;
        this.sigmlPos.set(IX, this.prevDot);
        this.deltaPos.set(IX, this.pos - this.prevDot);
        this.undoMgr.addEdit(uedit);
        this.updateUndoAndRedoActionStates();
    }

    protected boolean canMergeAt(int IX) {
        boolean canmerge = false;
        if (IX != 0 && IX != this.ixEditLimit) {
            int DELTA_LEN = this.deltaLen.get(IX);
            int PREV_DELTA_LEN = this.deltaLen.get(IX - 1);
            if ((DELTA_LEN == 1 || DELTA_LEN == -1) && DELTA_LEN == PREV_DELTA_LEN) {
                int POS = this.sigmlPos.get(IX);
                int PREV_POS = this.sigmlPos.get(IX - 1);
                int DELTA_POS = this.deltaPos.get(IX);
                int PREV_DELTA_POS = this.deltaPos.get(IX - 1);
                if (POS == PREV_POS + PREV_DELTA_POS) {
                    canmerge = DELTA_LEN == 1 || DELTA_POS == PREV_DELTA_POS;
                }
            }
        }
        return canmerge;
    }

    protected void performUndo() {
        int IX = this.ixEdit - 1;
        boolean UNDELETING = this.deltaLen.get(IX) < 0;
        int INIT_DELTA_POS = this.deltaPos.get(IX);
        int INIT_POS = this.sigmlPos.get(IX) + INIT_DELTA_POS;
        int INIT_LEN = this.len;
        try {
            this.undoMgr.undo();
            --this.ixEdit;
            while (this.canMergeAt(this.ixEdit)) {
                this.undoMgr.undo();
                --this.ixEdit;
            }
        }
        catch (CannotUndoException cux) {
            System.err.println("ssclient.SiGMLUndoController: UNDO fails: " + cux);
        }
        this.len = this.sigmlLength();
        if (UNDELETING) {
            boolean IS_FWD = INIT_DELTA_POS == 0;
            int DELTA_LEN = this.len - INIT_LEN;
            this.pos = IS_FWD ? INIT_POS : this.currDot;
            int MARK = IS_FWD ? this.pos + DELTA_LEN : INIT_POS;
            this.SIGML_TEXT_AREA.setCaretPosition(MARK);
            this.SIGML_TEXT_AREA.moveCaretPosition(this.pos);
        }
        this.updateUndoAndRedoActionStates();
    }

    protected void performRedo() {
        int IX = this.ixEdit;
        boolean REINSERTING = 0 < this.deltaLen.get(this.ixEdit);
        int INIT_POS = this.sigmlPos.get(IX);
        try {
            this.undoMgr.redo();
            ++this.ixEdit;
            while (this.canMergeAt(this.ixEdit)) {
                this.undoMgr.redo();
                ++this.ixEdit;
            }
        }
        catch (CannotRedoException crx) {
            System.err.println("ssclient.SiGMLUndoController: REDO fails: " + crx);
        }
        this.len = this.sigmlLength();
        this.pos = this.currDot;
        if (REINSERTING) {
            this.SIGML_TEXT_AREA.setCaretPosition(INIT_POS);
            this.SIGML_TEXT_AREA.moveCaretPosition(this.pos);
        }
        this.updateUndoAndRedoActionStates();
    }

    protected void updateUndoAndRedoActionStates() {
        this.UNDO_ACTION.setEnabled(this.undoMgr.canUndo());
        this.REDO_ACTION.setEnabled(this.undoMgr.canRedo());
    }

    static {
        UNDO_MASK = CMD_OR_CTRL_MASK = IS_MAC_OS_X ? 256 : 128;
        REDO_MASK = CMD_OR_CTRL_MASK | 0x40;
    }

    protected class SiGMLRedoAction
    extends AbstractAction {
        public SiGMLRedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SiGMLUndoController.this.performRedo();
        }
    }

    protected class SiGMLUndoAction
    extends AbstractAction {
        public SiGMLUndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            SiGMLUndoController.this.performUndo();
        }
    }
}

