/*
 * Decompiled with CFR 0.152.
 */
package ssclient;

import hnscnvt.HNSSign;
import hnsgen.GToHNSSignSiGML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import sigmlinlib.SiGMLInLib;
import ssclient.FileList;
import ssclient.HNSTableSuppport;
import ssclient.SiGMLUndoController;
import xml.XMLBytesDecoder;

public class SiGMLSignClient {
    public static final String DATE = "2010-01-05";
    private static final String DEFAULT_JA_VERSION = "0.9.5e";
    private static final String JA_PREFS_BASE = "uk/ac/uea/cmp/ja";
    private static final String SS_CLIENT_PREFS = "SSClient";
    private static final String STD_ENCODING = "utf-8";
    public final String JA_VERSION;
    public final String JA_VERSION_TAG;
    private static final String SIGML_FOLDER_KEY = "sigml.folder";
    private static final String LOCAL_HOST = "localhost";
    private static final int SIGML_PORT = 8052;
    private static final String EOL = "\n";
    private static final String EOL_F = System.getProperty("line.separator", "\n");
    private static final Font FONT_LUCIDA_C = new Font("Lucida Console", 0, 12);
    private String server;
    private int port;
    private String folder;
    private Preferences ssClientPrefs = null;
    private SiGMLInLib siLib;
    private JFrame frmMain;
    private JSplitPane spltSiGMLHNS;
    private JTextArea txtSiGML;
    private JPanel paneHNS;
    private JTable tblHNS;
    private JScrollPane scrllHNS;
    private Box boxCtrlPanel;
    private FileList fileList;
    private JTextField txtfFile;
    private JButton bttnSave;
    private JButton bttnSetDir;
    private JCheckBox chkConvert;
    private JButton bttnRefresh;
    private JTextField txtfServer;
    private JButton bttnSend;
    protected SiGMLUndoController undoController;
    protected static final String NOT_HNST = ".hnst file does not look like HNST!";
    protected static final String NOT_SIGML = ".[e]sigml file does not look like SiGML!";
    protected static final String MAYBE_BOTH_S_AND_H = "File looks like both SiGML and HNST!";
    protected static final String NEITHER_S_OR_H = "File looks like neither SiGML nor HNST!";

    public static void main(String[] args) {
        String javn = DEFAULT_JA_VERSION;
        if (args != null && 1 <= args.length) {
            javn = args[0];
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception x) {
            System.out.println(x.getMessage());
        }
        SiGMLSignClient client = new SiGMLSignClient(javn);
    }

    public SiGMLSignClient(String javersion) {
        this(javersion, LOCAL_HOST, 8052);
    }

    public SiGMLSignClient(String javersion, String srvr) {
        this(javersion, srvr, 8052);
    }

    public SiGMLSignClient(String javersion, String srvr, int port) {
        this.JA_VERSION = javersion;
        this.JA_VERSION_TAG = this.JA_VERSION.replaceAll("\\.", "");
        this.server = srvr;
        this.port = port;
        this.initFolder();
        this.siLib = new SiGMLInLib();
        this.makeGUI();
    }

    protected Preferences getSSClientPreferences() {
        if (this.ssClientPrefs == null) {
            try {
                String PREFS_PATH = "uk/ac/uea/cmp/ja/" + this.JA_VERSION_TAG + "/" + SS_CLIENT_PREFS;
                Preferences uprefs = Preferences.userRoot();
                this.ssClientPrefs = uprefs.node(PREFS_PATH);
            }
            catch (IllegalStateException ise) {
                System.out.println("####  getSSClientPreferences(): " + ise);
            }
        }
        return this.ssClientPrefs;
    }

    protected void updateFolderInPrefs() {
        Preferences sscnode = this.getSSClientPreferences();
        if (sscnode != null && this.folder != null) {
            sscnode.put(SIGML_FOLDER_KEY, this.folder);
        }
    }

    protected void initFolder() {
        this.folder = null;
        File fldr = this.getFolderFromPrefs();
        if (fldr != null) {
            this.folder = fldr.getAbsolutePath();
        } else {
            fldr = this.getInputDirectory();
            if (fldr == null) {
                fldr = new File(System.getProperty("user.dir"));
            }
            this.folder = fldr.getAbsolutePath();
            this.updateFolderInPrefs();
        }
    }

    protected File getFolderFromPrefs() {
        String sf;
        File fldr = null;
        Preferences sscnode = this.getSSClientPreferences();
        if (sscnode != null && (sf = sscnode.get(SIGML_FOLDER_KEY, null)) != null && !(fldr = new File(sf)).isDirectory()) {
            fldr = null;
        }
        return fldr;
    }

    protected void doCloseClient() {
        boolean cancelclose = false;
        if (this.undoController.sigmlTextIsDirty()) {
            int savechoice = JOptionPane.showConfirmDialog(this.frmMain, "The SiGML text has been modified.\nSave it before closing?");
            if (savechoice == 0) {
                this.tryToSaveSiGML();
            }
            cancelclose = savechoice == 2;
        }
        int CLOSE_OP = cancelclose ? 0 : 3;
        this.frmMain.setDefaultCloseOperation(CLOSE_OP);
        String CLOSE_END = cancelclose ? "close aborted." : "closed.";
        System.out.println("SiGML-Sign-Editor/Client " + CLOSE_END);
    }

    protected void doRefreshFileList() {
        this.fileList.refresh();
        this.frmMain.validate();
    }

    protected void doSetDirectory() {
        File dir = this.getInputDirectory();
        if (dir != null) {
            this.folder = dir.getAbsolutePath();
            this.updateFolderInPrefs();
            this.fileList.setFolder(dir);
        }
    }

    protected void doGetSiGML(File sfile) {
        String sigml;
        boolean doabort = false;
        if (this.undoController.sigmlTextIsDirty()) {
            int SAVE_CHOICE = JOptionPane.showConfirmDialog(this.frmMain, "The SiGML text has been modified.\nSave it before disposing of it?");
            if (SAVE_CHOICE == 2) {
                doabort = true;
            } else if (SAVE_CHOICE == 0) {
                boolean saved = this.tryToSaveSiGML();
                boolean bl = doabort = !saved;
            }
        }
        if (!doabort && (sigml = this.getSiGML(sfile)) != null) {
            String sigmln = sigml.replaceAll("\r\n", EOL);
            this.txtfFile.setText(sfile.getName());
            this.txtfFile.setCaretPosition(0);
            this.showSiGML(sigmln);
            this.showHNS(sigmln);
            this.bttnSave.setEnabled(true);
            this.bttnSend.setEnabled(true);
        }
    }

    protected void doSendSiGML() {
        String stxt = this.txtSiGML.getText();
        this.sendSiGML(stxt);
    }

    protected void doSaveSiGML() {
        boolean saved = this.tryToSaveSiGML();
        if (saved) {
            this.undoController.setCleanSiGMLText();
        }
    }

    protected boolean tryToSaveSiGML() {
        boolean donesave = false;
        File sfile = this.getOutputFile();
        if (sfile != null) {
            boolean oktosave = true;
            if (sfile.exists()) {
                int OW_CHOICE = JOptionPane.showConfirmDialog(this.frmMain, "File \"" + sfile.getName() + "\" already exists." + "  Overwrite?", "Overwrite Existing File?", 0);
                boolean bl = oktosave = OW_CHOICE == 0;
            }
            if (oktosave) {
                String stxt = this.txtSiGML.getText();
                String stxtf = stxt.replaceAll(EOL, EOL_F);
                this.writeSiGMLTextFile(sfile, stxtf);
                this.doRefreshFileList();
                donesave = true;
            }
        }
        return donesave;
    }

    protected File getOutputFile() {
        JFileChooser chooser = new JFileChooser(this.folder);
        String title = "Save SiGML File As...";
        File sfile = this.getSaveFile(chooser, title, this.frmMain);
        return sfile;
    }

    protected File getInputDirectory() {
        JFileChooser chooser = new JFileChooser(this.folder);
        String title = "SiGML Input Directory?";
        File dir = this.getInputDirectory(chooser, title, this.frmMain);
        return dir;
    }

    protected String getSiGML(File infile) {
        boolean sraw;
        String gsigml = null;
        String sigml = null;
        boolean bl = sraw = !this.chkConvert.isSelected();
        if (infile != null) {
            String fname = infile.getAbsolutePath();
            String intxt = this.getFileText(infile);
            String hnst = null;
            if (fname.endsWith(".hnst")) {
                if (!this.checkHNST(intxt)) {
                    this.showMessage(NOT_HNST);
                } else {
                    hnst = intxt;
                }
            } else if (fname.endsWith(".sigml") || fname.endsWith(".esigml")) {
                if (!this.checkSiGML(intxt)) {
                    this.showMessage(NOT_SIGML);
                } else {
                    sigml = intxt;
                }
            } else {
                boolean chksigml;
                boolean chkhnst = this.checkHNST(intxt);
                if (chkhnst == (chksigml = this.checkSiGML(intxt))) {
                    this.showMessage(chkhnst ? MAYBE_BOTH_S_AND_H : NEITHER_S_OR_H);
                } else if (chkhnst) {
                    hnst = intxt;
                } else if (chksigml) {
                    sigml = intxt;
                }
            }
            if (hnst != null | (sigml != null && !sraw)) {
                String[] svec = hnst != null ? this.siLib.hnstSignsToSiGML(hnst) : this.siLib.sigmlSignsToGestural(sigml);
                String err = svec[3];
                if (err.length() != 0) {
                    this.showMessage(err);
                } else {
                    gsigml = svec[1];
                }
            }
        }
        return sraw && sigml != null ? sigml : gsigml;
    }

    protected void showSiGML(String sigml) {
        this.undoController.endSupportForOldSiGML();
        this.txtSiGML.setText("");
        this.txtSiGML.append(sigml);
        this.txtSiGML.setCaretPosition(0);
        this.undoController.beginSupportForNewSiGML();
    }

    protected void showSiGML(String[] sigml) {
        this.txtSiGML.setText("");
        int N = sigml.length;
        for (int i = 0; i != N; ++i) {
            this.txtSiGML.append(sigml[i] + EOL);
        }
        this.txtSiGML.setCaretPosition(0);
    }

    protected void showHNS(String sigml) {
        HNSSign[] hsigns = null;
        try {
            String[] gsdata = this.siLib.sigmlSignsToGestural(sigml);
            String gsigml = gsdata[1];
            if (gsigml != null) {
                hsigns = this.siLib.gesturalSiGMLToHNS(gsigml);
            }
        }
        catch (GToHNSSignSiGML.GToHNSException ghx) {
            this.showMessage(ghx.getMessage());
        }
        if (hsigns != null) {
            this.tblHNS = HNSTableSuppport.makeHNSTable(hsigns);
            this.tblHNS.setPreferredScrollableViewportSize(new Dimension(this.txtSiGML.getWidth(), 96));
            if (this.scrllHNS != null) {
                this.paneHNS.remove(this.scrllHNS);
            }
            this.scrllHNS = new JScrollPane(this.tblHNS);
            this.paneHNS.add((Component)this.scrllHNS, "Center");
            this.paneHNS.repaint();
            this.frmMain.validate();
        }
    }

    protected void sendSiGML(String sigml) {
        this.server = this.txtfServer.getText();
        try {
            Socket csock = new Socket(this.server, this.port);
            PrintWriter swrtr = this.getPrintWriterForSiGML(csock, sigml);
            swrtr.print(sigml);
            swrtr.close();
            csock.close();
        }
        catch (IOException iox) {
            String mpfx = "sendSiGML() (" + this.server + "," + this.port + "): ";
            this.showMessage(mpfx + iox.getMessage());
        }
    }

    protected boolean checkHNST(String txt) {
        Pattern cmmntpat = Pattern.compile("[\\t ]*#");
        Matcher mtchr = cmmntpat.matcher(txt);
        while (mtchr.lookingAt()) {
            int i = txt.indexOf(EOL);
            i = i <= 0 ? txt.length() : i + EOL.length();
            txt = txt.substring(i);
            mtchr = cmmntpat.matcher(txt);
        }
        Pattern hopenpat = Pattern.compile("\\s*\\[\\s*\\[\\s*\\[");
        return hopenpat.matcher(txt).lookingAt();
    }

    protected boolean checkSiGML(String txt) {
        Matcher mtchr = Pattern.compile("[\\s]*<").matcher(txt);
        boolean xmlok = mtchr.lookingAt();
        return xmlok & 0 <= txt.indexOf("<sigml");
    }

    protected void makeGUI() {
        this.makeSiGMLTextArea();
        this.makeServerNameTextField();
        this.makeFileNameTextField();
        this.makeFileList();
        this.makeButtonsForFileManagement();
        this.makeButtonForSiGMLSend();
        this.makeSiGMLAndHNSPane();
        Box fbox = this.makeFileListBox();
        Box bbox = this.makeFileControlsBox();
        Box sbox = this.makeSiGMLSendControlsBox();
        this.makeSiGMLIOControlPanel(fbox, bbox, sbox);
        JPanel mainpane = new JPanel(new BorderLayout(2, 2));
        mainpane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        mainpane.add((Component)this.spltSiGMLHNS, "Center");
        mainpane.add((Component)this.boxCtrlPanel, "South");
        this.makeMainWindow(mainpane);
        this.bttnSend.setEnabled(false);
        this.bttnSave.setEnabled(false);
        this.undoController = new SiGMLUndoController(this.txtSiGML);
        this.frmMain.setVisible(true);
    }

    protected static JButton makeButton(String btxt, Dimension sz) {
        JButton bttn = new JButton(btxt);
        bttn.setMinimumSize(sz);
        bttn.setMaximumSize(sz);
        bttn.setPreferredSize(sz);
        return bttn;
    }

    protected void makeSiGMLTextArea() {
        this.txtSiGML = new JTextArea(28, 80){

            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHints(HNSTableSuppport.AA_HINTS);
                super.paintComponent(g);
            }
        };
        this.txtSiGML.setFont(FONT_LUCIDA_C);
        this.txtSiGML.setMargin(new Insets(4, 4, 4, 4));
        this.txtSiGML.setTabSize(4);
    }

    protected void makeServerNameTextField() {
        this.txtfServer = new JTextField(this.server, 12){

            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHints(HNSTableSuppport.AA_HINTS);
                super.paintComponent(g);
            }
        };
        Dimension tsdim = this.txtfServer.getPreferredSize();
        this.txtfServer.setMinimumSize(tsdim);
        this.txtfServer.setMaximumSize(tsdim);
    }

    protected void makeFileNameTextField() {
        this.txtfFile = new JTextField("", 16){

            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHints(HNSTableSuppport.AA_HINTS);
                super.paintComponent(g);
            }
        };
        this.txtfFile.setEditable(false);
        Dimension tfdim = this.txtfFile.getPreferredSize();
        this.txtfFile.setMinimumSize(tfdim);
        this.txtfFile.setMaximumSize(tfdim);
    }

    protected void makeFileList() {
        this.fileList = new FileList(this.folder);
        this.fileList.setSelectionReceiver(new FileList.SelectionReceiver(){

            public void newFileSelected(File file) {
                SiGMLSignClient.this.doGetSiGML(file);
            }
        });
    }

    protected void makeButtonsForFileManagement() {
        Dimension bfdim = new Dimension(144, 28);
        this.bttnSave = SiGMLSignClient.makeButton("Save SiGML...", bfdim);
        this.bttnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aevt) {
                SiGMLSignClient.this.doSaveSiGML();
            }
        });
        this.bttnSetDir = SiGMLSignClient.makeButton("Set Directory...", bfdim);
        this.bttnSetDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aevt) {
                SiGMLSignClient.this.doSetDirectory();
            }
        });
        this.chkConvert = new JCheckBox("Convert SiGML", false);
        this.bttnRefresh = SiGMLSignClient.makeButton("Refresh List", bfdim);
        this.bttnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aevt) {
                SiGMLSignClient.this.doRefreshFileList();
            }
        });
    }

    protected void makeButtonForSiGMLSend() {
        Dimension bsdim = new Dimension(this.txtfServer.getPreferredSize().width, 28);
        this.bttnSend = SiGMLSignClient.makeButton("Send SiGML", bsdim);
        this.bttnSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent aevt) {
                SiGMLSignClient.this.doSendSiGML();
            }
        });
    }

    protected void makeSiGMLAndHNSPane() {
        JScrollPane sscrll = new JScrollPane(this.txtSiGML);
        this.paneHNS = new JPanel(new BorderLayout(2, 2));
        this.paneHNS.setPreferredSize(new Dimension(this.txtSiGML.getWidth(), 96));
        this.spltSiGMLHNS = new JSplitPane(0, true, sscrll, this.paneHNS);
        this.spltSiGMLHNS.setOneTouchExpandable(true);
    }

    protected Box makeFileListBox() {
        JScrollPane fscroller = this.fileList.getFilesScroller(240, 10);
        fscroller.setAlignmentX(0.0f);
        Box fbox = Box.createVerticalBox();
        fbox.add(new JLabel("Files:"));
        fbox.add(fscroller);
        return fbox;
    }

    protected Box makeFileControlsBox() {
        this.txtfFile.setAlignmentX(0.0f);
        Box bbox = Box.createVerticalBox();
        bbox.add(new JLabel("Current SiGML File:"));
        bbox.add(Box.createRigidArea(new Dimension(0, 2)));
        bbox.add(this.txtfFile);
        bbox.add(Box.createRigidArea(new Dimension(0, 6)));
        bbox.add(this.bttnSave);
        bbox.add(Box.createVerticalGlue());
        bbox.add(this.chkConvert);
        bbox.add(Box.createRigidArea(new Dimension(0, 2)));
        bbox.add(this.bttnSetDir);
        bbox.add(Box.createRigidArea(new Dimension(0, 6)));
        bbox.add(this.bttnRefresh);
        return bbox;
    }

    protected Box makeSiGMLSendControlsBox() {
        this.txtfServer.setAlignmentX(0.0f);
        Box sbox = Box.createVerticalBox();
        sbox.add(new JLabel("Server:"));
        sbox.add(Box.createRigidArea(new Dimension(0, 2)));
        sbox.add(this.txtfServer);
        sbox.add(Box.createRigidArea(new Dimension(0, 6)));
        sbox.add(this.bttnSend);
        sbox.add(Box.createVerticalGlue());
        return sbox;
    }

    protected void makeSiGMLIOControlPanel(Box fbox, Box bbox, Box sbox) {
        fbox.setAlignmentY(0.0f);
        bbox.setAlignmentY(0.0f);
        sbox.setAlignmentY(0.0f);
        this.boxCtrlPanel = Box.createHorizontalBox();
        this.boxCtrlPanel.add(fbox);
        this.boxCtrlPanel.add(Box.createRigidArea(new Dimension(16, 0)));
        this.boxCtrlPanel.add(bbox);
        this.boxCtrlPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.boxCtrlPanel.add(Box.createHorizontalGlue());
        this.boxCtrlPanel.add(sbox);
    }

    protected void makeMainWindow(JPanel mainpane) {
        this.frmMain = new JFrame();
        this.frmMain.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent wevt) {
                SiGMLSignClient.this.doCloseClient();
            }
        });
        String title = "SiGML Editor/Animation-Client";
        String version = "   v" + this.JA_VERSION + "  (" + DATE + ")";
        this.frmMain.setTitle(title + version);
        this.frmMain.setContentPane(mainpane);
        this.frmMain.pack();
    }

    protected void showMessage(String msg) {
        JOptionPane.showMessageDialog(this.frmMain, msg);
    }

    protected PrintWriter getPrintWriter(OutputStream outs) {
        return this.getPrintWriter(outs, STD_ENCODING);
    }

    protected PrintWriter getPrintWriter(OutputStream outs, String enc) {
        PrintWriter pwrtr = null;
        try {
            OutputStreamWriter osw = new OutputStreamWriter(outs, enc);
            pwrtr = new PrintWriter((Writer)osw, true);
        }
        catch (IOException iox) {
            this.showMessage("getPrintWriter(): " + iox.getMessage());
        }
        return pwrtr;
    }

    protected PrintWriter getPrintWriterForSiGML(Socket sock, String sigml) {
        PrintWriter pwrtr = null;
        try {
            String ENC = SiGMLSignClient.encodingForSiGML(sigml);
            pwrtr = this.getPrintWriter(sock.getOutputStream(), ENC);
        }
        catch (IOException iox) {
            this.showMessage("getPrintWriter(): " + iox.getMessage());
        }
        return pwrtr;
    }

    protected File getInputDirectory(JFileChooser fc, String title, Component parent) {
        File dir = null;
        fc.setDialogTitle(title);
        fc.setFileSelectionMode(1);
        int fcResult = fc.showOpenDialog(parent);
        if (fcResult == 0) {
            dir = fc.getSelectedFile();
        }
        return dir;
    }

    protected File getSaveFile(JFileChooser fc, String title, Component parent) {
        File f = null;
        fc.setDialogTitle(title);
        fc.setFileSelectionMode(0);
        int fcResult = fc.showSaveDialog(parent);
        if (fcResult == 0) {
            f = fc.getSelectedFile();
        }
        return f;
    }

    protected String getFileText(File f) {
        String txt = "";
        byte[] fbytes = this.getFileBytes(f);
        if (fbytes != null) {
            try {
                XMLBytesDecoder xbd = new XMLBytesDecoder(fbytes);
                txt = xbd.getXMLString();
            }
            catch (IOException iox) {
                this.showMessage("getFileText(): " + iox.getMessage());
            }
        }
        return txt;
    }

    protected byte[] getFileBytes(File f) {
        byte[] bytes = null;
        try {
            FileInputStream tins = new FileInputStream(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            byte[] buf = new byte[1024];
            int n = ((InputStream)tins).read(buf);
            while (0 < n) {
                baos.write(buf, 0, n);
                n = ((InputStream)tins).read(buf);
            }
            baos.flush();
            bytes = baos.toByteArray();
            baos = null;
        }
        catch (IOException iox) {
            this.showMessage("getFileBytes(): " + iox.getMessage());
        }
        return bytes;
    }

    protected String[] getFileTextLines(File f) {
        String[] lines = null;
        try {
            ArrayList<String> lnlist = new ArrayList<String>();
            BufferedReader trdr = new BufferedReader(new FileReader(f));
            String ln = trdr.readLine();
            while (ln != null) {
                lnlist.add(ln);
                ln = trdr.readLine();
            }
            lines = new String[lnlist.size()];
            lnlist.toArray(lines);
        }
        catch (IOException iox) {
            this.showMessage("getFileTextLines(): " + iox.getMessage());
        }
        return lines;
    }

    protected void writeSiGMLTextFile(File f, String stxt) {
        try {
            String ENC = SiGMLSignClient.encodingForSiGML(stxt);
            FileOutputStream fouts = new FileOutputStream(f);
            OutputStreamWriter wrtr = new OutputStreamWriter((OutputStream)fouts, ENC);
            BufferedWriter fwrtr = new BufferedWriter(wrtr);
            fwrtr.write(stxt);
            fwrtr.flush();
            fwrtr.close();
        }
        catch (IOException iox) {
            this.showMessage("writeSiGMLTextFile(): " + iox.getMessage());
        }
    }

    protected static String encodingForSiGML(String sigml) {
        String S_ENC = XMLBytesDecoder.explicitEncoding(sigml);
        String ENC = S_ENC != null ? S_ENC : STD_ENCODING;
        String DFLT = S_ENC == null ? " (default)" : "";
        System.out.println("####  SiGML output encoding" + DFLT + ": " + ENC);
        return ENC;
    }
}

