/*
 * Decompiled with CFR 0.152.
 */
package ssclient;

import hnscnvt.HNSSign;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import util.HNSOctetUCSMap;

public class HNSTableSuppport {
    public static final Font FONT_LUCIDA_C = new Font("Lucida Console", 0, 12);
    public static final Font FONT_COURIER = new Font("Courier New", 0, 14);
    public static final Font FONT_HNS_U = new Font("Hamnosysunicode", 0, 20);
    public static final RenderingHints AA_HINTS = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

    public static JTable makeHNSTable(HNSSign[] signs) {
        HNSModel hmodel = new HNSModel(signs);
        JTable htable = new JTable(hmodel);
        HNSManCellRenderer hmanrndrr = new HNSManCellRenderer();
        HNSStdCellRenderer hstdrndrr = new HNSStdCellRenderer();
        HNSManCellEditor hmaneditor = new HNSManCellEditor();
        HNSStdCellEditor hstdeditor = new HNSStdCellEditor();
        htable.setRowHeight(24);
        int NC = hmodel.getColumnCount();
        int[] widths = new int[]{40, 300, 30};
        SSCCellRenderer[] rndrrs = new SSCCellRenderer[]{hstdrndrr, hmanrndrr, hstdrndrr};
        SSCCellEditor[] editors = new SSCCellEditor[]{hstdeditor, hmaneditor, hstdeditor};
        for (int i = 0; i != NC; ++i) {
            TableColumn hmcol = htable.getColumnModel().getColumn(i);
            hmcol.setPreferredWidth(widths[i]);
            hmcol.setCellRenderer(rndrrs[i]);
            hmcol.setCellEditor(editors[i]);
        }
        return htable;
    }

    public static class HNSStdCellEditor
    extends SSCCellEditor {
        public HNSStdCellEditor() {
            this.rendererFont = FONT_LUCIDA_C;
        }
    }

    public static class HNSManCellEditor
    extends SSCCellEditor {
        public HNSManCellEditor() {
            this.rendererFont = FONT_HNS_U;
        }
    }

    public static abstract class SSCCellEditor
    extends DefaultCellEditor {
        protected Font rendererFont;
        protected static RenderingHints aaHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

        public SSCCellEditor() {
            super(new JTextField(){

                protected void paintComponent(Graphics g) {
                    ((Graphics2D)g).setRenderingHints(aaHints);
                    super.paintComponent(g);
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object item, boolean isSelected, int row, int col) {
            Component cpt = super.getTableCellEditorComponent(table, (String)item, isSelected, row, col);
            cpt.setFont(this.rendererFont);
            return cpt;
        }
    }

    public static class HNSStdCellRenderer
    extends SSCCellRenderer {
        public HNSStdCellRenderer() {
            this.rendererFont = FONT_LUCIDA_C;
        }
    }

    public static class HNSManCellRenderer
    extends SSCCellRenderer {
        public HNSManCellRenderer() {
            this.rendererFont = FONT_HNS_U;
        }
    }

    public static abstract class SSCCellRenderer
    extends DefaultTableCellRenderer {
        protected Font rendererFont;

        public Component getTableCellRendererComponent(JTable table, Object item, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, (String)item, isSelected, hasFocus, row, col);
            this.setFont(this.rendererFont);
            return this;
        }

        protected void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHints(AA_HINTS);
            super.paintComponent(g);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HNSModel
    extends AbstractTableModel {
        private HNSOctetUCSMap humap = HNSOctetUCSMap.getHNSMapOctetAllUCS();
        private int size;
        private String[] colNames = new String[]{"Gloss", "HNS-Man", "HNS-Non-Man"};
        private String[] data = new String[]{new String(), new String(), new String()};
        private HNSSign[] signs;

        public HNSModel(HNSSign[] signs) {
            this.signs = signs;
            this.size = this.signs.length;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return this.size;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            String val = null;
            if (row < this.size) {
                HNSSign sign = this.signs[row];
                if (col == 0) {
                    val = sign.gloss();
                } else if (col == 1) {
                    val = this.humap.ucs(sign.man());
                } else if (col == 2) {
                    val = sign.nonMan();
                }
                if (val == null) {
                    val = "";
                }
            }
            return val;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String sval = (String)value;
            if (row < this.size) {
                HNSSign sign = this.signs[row];
                if (col == 0) {
                    sign.setGloss(sval);
                } else if (col == 1) {
                    sign.setMan(this.humap.octet(sval));
                } else if (col == 2) {
                    sign.setNonMan(sval);
                }
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

