/*
 * Decompiled with CFR 0.152.
 */
package ssclient;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class FileList {
    public static final RenderingHints AA_HINTS = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    protected JList list;
    protected JScrollPane scroller;
    protected DefaultListModel listModel;
    protected File folder;
    protected String[] fileNames;
    protected SelectionReceiver receiver;

    public FileList(String fpath) {
        File file = this.folder = fpath == null ? null : new File(fpath);
        if (this.folder == null || !this.folder.exists() || !this.folder.isDirectory()) {
            String upath = System.getProperty("user.dir");
            this.folder = new File(upath);
        }
        this.setFileNames();
        this.createListModelFromFileNames();
        this.createListGUI();
    }

    public JScrollPane getFilesScroller(int wpxls, int nitms) {
        this.list.setVisibleRowCount(nitms);
        Dimension sdim = this.scroller.getPreferredSize();
        Dimension newdim = new Dimension(wpxls, sdim.height);
        this.scroller.setPreferredSize(newdim);
        return this.scroller;
    }

    public void setSelectionReceiver(SelectionReceiver srcvr) {
        this.receiver = srcvr;
    }

    public void setFolder(File fldr) {
        if (fldr.isDirectory()) {
            this.folder = fldr;
            this.refresh();
        }
    }

    public void refresh() {
        this.listModel.clear();
        this.setFileNames();
        this.createListModelFromFileNames();
        this.list.setModel(this.listModel);
        this.scroller.revalidate();
    }

    protected void fireSelected(int index) {
        if (this.receiver != null) {
            String fname = (String)this.listModel.get(index);
            File sfile = new File(this.folder, fname);
            this.receiver.newFileSelected(sfile);
        }
    }

    protected void createListGUI() {
        this.list = new JList(this.listModel){

            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHints(AA_HINTS);
                super.paintComponent(g);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(10);
        this.list.setToolTipText("Double-click a file to select it.");
        MouseAdapter mlstnr = new MouseAdapter(){

            public void mouseClicked(MouseEvent mevt) {
                Rectangle crect;
                Point cpt;
                JList flist;
                int ix;
                if (mevt.getClickCount() == 2 && 0 <= (ix = (flist = FileList.this.list).locationToIndex(cpt = mevt.getPoint())) && (crect = flist.getCellBounds(ix, ix)).contains(cpt)) {
                    FileList.this.fireSelected(ix);
                }
            }
        };
        this.list.addMouseListener(mlstnr);
        this.scroller = new JScrollPane(this.list);
        ListModel mdl = this.list.getModel();
        int N = mdl.getSize();
        for (int i = 0; i != N; ++i) {
            String item = (String)mdl.getElementAt(i);
        }
    }

    protected void createListModelFromFileNames() {
        this.listModel = new DefaultListModel();
        int N = this.fileNames.length;
        for (int i = 0; i != N; ++i) {
            this.listModel.addElement(this.fileNames[i]);
        }
    }

    protected void setFileNames() {
        File[] files = this.folder.listFiles();
        int N = files.length;
        ArrayList<String> names = new ArrayList<String>(N);
        for (int i = 0; i != N; ++i) {
            File f = files[i];
            if (!f.isFile()) continue;
            names.add(f.getName());
        }
        int M = names.size();
        this.fileNames = new String[M];
        names.toArray(this.fileNames);
    }

    public static interface SelectionReceiver {
        public void newFileSelected(File var1);
    }
}

