/*
 * Decompiled with CFR 0.152.
 */
package sigmlstream.xml;

import java.util.ArrayList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import sigmlstream.xml.XMLUnitEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUnitReader
implements XMLReader {
    private final InputSource FIXED_DUMMY_SOURCE;
    private final ArrayList<XMLUnitEvent> EVENTS;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;

    public XMLUnitReader(InputSource fixsrc, ArrayList<XMLUnitEvent> events) {
        this.FIXED_DUMMY_SOURCE = fixsrc;
        this.EVENTS = events;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        if (input != this.FIXED_DUMMY_SOURCE) {
            throw new SAXException("XMLUnitReader: invalid parse source.");
        }
        if (this.contentHandler != null) {
            for (XMLUnitEvent uevt : this.EVENTS) {
                uevt.feedToContentHandler(this.contentHandler);
            }
        }
    }

    @Override
    public void parse(String systemid) throws SAXException {
        throw new SAXException("XMLUnitReader does not parse from SystemID.");
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler chdlr) {
        this.contentHandler = chdlr;
    }

    @Override
    public void setDTDHandler(DTDHandler dhdlr) {
    }

    @Override
    public void setEntityResolver(EntityResolver erslvr) {
    }

    @Override
    public void setErrorHandler(ErrorHandler ehdlr) {
        this.errorHandler = ehdlr;
    }

    @Override
    public void setFeature(String name, boolean feature) {
    }

    @Override
    public void setProperty(String name, Object property) {
    }
}

