/*
 * Decompiled with CFR 0.152.
 */
package sigmlstream.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import sigmlstream.xml.EndDocumentEvent;
import sigmlstream.xml.EndElementEvent;
import sigmlstream.xml.StartDocumentEvent;
import sigmlstream.xml.StartElementEvent;
import sigmlstream.xml.XMLUnitEvent;
import sigmlstream.xml.XMLUnitStreamHandler;

public class XMLUnitFilter
extends XMLFilterImpl {
    protected final XMLUnitStreamHandler XUS_HANDLER;
    protected int level;
    protected ArrayList<XMLUnitEvent> unitEvents;

    public XMLUnitFilter(XMLReader parent, XMLUnitStreamHandler xushdlr) {
        super(parent);
        this.XUS_HANDLER = xushdlr;
        this.level = 0;
        this.unitEvents = null;
    }

    public int getLevel() {
        return this.level;
    }

    protected XMLUnitStreamHandler getXMLUnitStreamHandler() {
        return this.XUS_HANDLER;
    }

    protected void beginUnit() throws SAXException {
        this.unitEvents = new ArrayList(32);
        this.unitEvents.add(new StartDocumentEvent());
    }

    protected void endUnit() {
        this.unitEvents.add(new EndDocumentEvent());
        this.XUS_HANDLER.notifyXMLUnit(this.unitEvents);
        this.unitEvents = null;
    }

    protected void beginStream() {
        this.XUS_HANDLER.notifyBeginXMLUnitStream();
    }

    protected void endStream() {
        this.XUS_HANDLER.notifyEndXMLUnitStream();
    }

    public void startElement(String uri, String lname, String qname, Attributes attrs) throws SAXException {
        if (this.level == 0) {
            this.beginStream();
        } else if (this.level == 1) {
            this.beginUnit();
        }
        if (this.unitEvents != null) {
            this.unitEvents.add(new StartElementEvent(uri, lname, qname, attrs));
        }
        ++this.level;
    }

    public void endElement(String uri, String lname, String qname) throws SAXException {
        --this.level;
        if (this.unitEvents != null) {
            this.unitEvents.add(new EndElementEvent(uri, lname, qname));
        }
        if (this.level == 1) {
            this.endUnit();
        } else if (this.level == 0) {
            this.endStream();
        }
    }
}

