/*
 * Decompiled with CFR 0.152.
 */
package sigmlinlib;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class SiGMLInputServiceBase {
    protected boolean doReport = true;
    protected String reportPrefix;
    protected int inServicePort;
    protected ServerSocket inServiceSocket;
    protected ServiceThread inServiceThread;
    protected boolean inServiceDone;
    protected ServiceOperations operations;
    protected int stopRequestPort;
    protected ServerSocket stopRequestSocket;
    protected ShutdownThread stopRequestThread;

    public SiGMLInputServiceBase(boolean rprt, String rprttag, int inport, int stopport, ServiceOperations sops) throws IOException {
        this.doReport = rprt;
        this.reportPrefix = "####  SiGMLInputService (" + rprttag + "): ";
        this.inServicePort = inport;
        this.stopRequestPort = stopport;
        this.operations = sops;
        this.inServiceDone = false;
        this.inServiceSocket = new ServerSocket(this.inServicePort, 1);
        this.launchInputServiceThread();
        this.stopRequestSocket = new ServerSocket(this.stopRequestPort, 1);
        this.stopRequestThread = new ShutdownThread(this.stopRequestPort, this.stopRequestSocket);
    }

    protected void launchInputServiceThread() {
        this.inServiceThread = new ServiceThread(this.inServicePort, this.inServiceSocket, this.operations);
        this.inServiceThread.start();
    }

    public void shutDown(boolean wait) throws IOException {
        if (this.stopRequestSocket != null) {
            this.stopRequestSocket.close();
            this.stopRequestSocket = null;
            this.stopRequestThread = null;
        }
        this.terminateInputService();
        if (wait) {
            this.waitForTermination();
        }
        this.report("service shut-down completed.");
    }

    protected synchronized void terminateInputService() {
        this.inServiceThread = null;
        try {
            this.inServiceSocket.close();
        }
        catch (IOException iox) {
            this.report("shut-down - " + iox.getMessage());
        }
    }

    protected synchronized void waitForTermination() {
        while (!this.inServiceDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void setInServiceTerminated() {
        this.inServiceDone = true;
        this.notify();
    }

    protected void report(String msg) {
        if (this.doReport) {
            System.out.println(this.reportPrefix + msg);
        }
    }

    protected class ShutdownThread
    extends Thread
    implements Runnable {
        protected int srPort;
        protected ServerSocket srSocket;

        public ShutdownThread(int srport, ServerSocket srsckt) {
            this.srPort = srport;
            this.srSocket = srsckt;
            this.start();
        }

        protected void threadReport(String str) {
            SiGMLInputServiceBase.this.report("(shutdown-thread) " + str);
        }

        public void run() {
            try {
                boolean gotShutPacket = false;
                this.threadReport("starting on " + this.srPort);
                while (!gotShutPacket) {
                    Socket sndrsock = this.srSocket.accept();
                    InetAddress sndraddr = sndrsock.getInetAddress();
                    if (sndraddr.equals(InetAddress.getLocalHost()) || sndraddr.getHostAddress().equals("127.0.0.1")) {
                        gotShutPacket = true;
                        continue;
                    }
                    String msg = "ignoring remote call from ";
                    msg = msg + sndraddr.toString() + ';';
                    this.threadReport(msg);
                }
                this.threadReport("stop-request received.");
                SiGMLInputServiceBase.this.shutDown(true);
            }
            catch (IOException iox) {
                this.threadReport(iox.getMessage() + ';');
            }
        }
    }

    protected class ServiceThread
    extends Thread {
        protected ServiceOperations serviceOps;
        protected int srvcPort;
        protected ServerSocket srvcSocket;
        protected String srvcTag;

        public ServiceThread(int port, ServerSocket ssckt, ServiceOperations sops) {
            this.serviceOps = sops;
            this.srvcPort = port;
            this.srvcSocket = ssckt;
            this.srvcTag = "(service-thread) ";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean threadDone() {
            SiGMLInputServiceBase sisthis;
            boolean done = false;
            SiGMLInputServiceBase siGMLInputServiceBase = sisthis = SiGMLInputServiceBase.this;
            synchronized (siGMLInputServiceBase) {
                done = sisthis.inServiceThread == null;
            }
            return done;
        }

        protected void threadReport(String str) {
            SiGMLInputServiceBase.this.report(this.srvcTag + str);
        }

        public void run() {
            this.serviceOps.beginService();
            while (!this.threadDone()) {
                try {
                    Socket ccsock = this.srvcSocket.accept();
                    this.threadReport("client accepted;");
                    this.serviceOps.processNextClientConnection(ccsock);
                    ccsock = null;
                    this.threadReport("client input done;");
                }
                catch (IOException iox) {
                    this.threadReport(iox.getMessage() + ';');
                }
            }
            this.serviceOps.endService();
            this.threadReport("shutting down.");
            SiGMLInputServiceBase.this.setInServiceTerminated();
        }
    }

    public static interface ServiceOperations {
        public void beginService();

        public void processNextClientConnection(Socket var1) throws IOException;

        public void endService();
    }
}

