/*
 * Decompiled with CFR 0.152.
 */
package sigmlinlib;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSInputAsSignSequence;
import hnscnvt.HNSSign;
import hnscnvt.HNSSignElementToHNS;
import hnscnvt.HNSStdAsSignSequence;
import hnscnvt.HNSTAsSignSequence;
import hnscnvt.HNSToHML;
import hnsgen.GToHNSSignSiGML;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerConfigurationException;
import sigmlgen.GSiGMLSign;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLDocHNSToGestural;
import sigmlgen.SiGMLDocToGSiGMLSigns;
import sigmlgen.SiGMLDocsFromHNSSource;
import sigmlgen.SiGMLResolver;
import sigmlinlib.BroadcastSiGMLInputService;
import sigmlinlib.BytesBlockStreamHandler;
import sigmlinlib.SIDefs;
import sigmlinlib.SiGMLInputService;
import sigmlinlib.SiGMLInputServiceStopper;
import sigmlinlib.StringStreamHandler;
import util.Logger;
import util.Logging;
import xml.CleanerEntityResolver;
import xml.XMLBytesDecoder;
import xml.XMLChildElementsExtractor;
import xml.XmlElementTextGen;

public class SiGMLInLib
implements BytesBlockStreamHandler,
StringStreamHandler {
    public static final int HGI_GESTURAL_SIGML = 0;
    public static final int HGI_ERROR_TEXT = 1;
    public static final int ASI_SIGML_IN = 0;
    public static final int ASI_SIGML_GESTURAL = 1;
    public static final int ASI_SIGML_IN_ERR_COUNT = 2;
    public static final int ASI_SIGML_ERROR_TEXT = 3;
    protected static boolean inputIsActive = false;
    protected SiGMLInputService inputServer;
    protected BroadcastSiGMLInputService broadcastInputServer;
    protected int inputKind = -1;
    protected int inputPort;
    protected int stopPort;
    protected HNSSignElementToHNS hstohConverter;
    protected HNSToHML htohConverter;
    protected HMLToSiGML htosConverter;
    protected GToHNSSignSiGML gtohConverter;
    protected XmlElementTextGen signsTextGen;
    protected Logging logger;
    private boolean doLogHML = false;

    public SiGMLInLib() {
        try {
            this.hstohConverter = new HNSSignElementToHNS();
            this.htohConverter = new HNSToHML();
            this.htosConverter = new HMLToSiGML();
            this.gtohConverter = new GToHNSSignSiGML();
        }
        catch (HNSToHML.HNSToHMLException hhx) {
            this.displayMessage("SiGMLInLib constructor", hhx.getMessage());
        }
        catch (HMLToSiGML.HMLToSiGMLException hsx) {
            this.displayMessage("SiGMLInLib constructor", hsx.getMessage());
        }
        catch (GToHNSSignSiGML.GToHNSException ghx) {
            this.displayMessage("SiGMLInLib constructor", ghx.getMessage());
        }
    }

    public synchronized String startSiGMLInputService(int informat, int inport, int stopport) {
        return this.doStartService(informat, inport, stopport);
    }

    public synchronized void stopSiGMLInputService() {
        this.doStopService();
    }

    public String[] hnsSignToGestural(String hnssignel) {
        return this.convertSiGMLHNSSignToGestural(hnssignel);
    }

    public String[] hnstSignsToSiGML(String hnst) {
        return this.sigmlGenFromHNSText(hnst, 0);
    }

    public String[] hnsStdSignsToSiGML(String hns) {
        return this.sigmlGenFromHNSText(hns, 1);
    }

    public String[] sigmlSignsToGestural(String sigml) {
        return this.sigmlConvertHNSToGestural(sigml, "sigml");
    }

    public GSiGMLSign[] sigmlToGSiGMLSigns(String sigml) {
        return this.sigmlToGSiGMLSigns(sigml, null);
    }

    public GSiGMLSign[] sigmlToGSiGMLSigns(String sigml, URI baseuri) {
        GSiGMLSign[] signs = null;
        boolean gerrs = false;
        try {
            SiGMLDocToGSiGMLSigns sgen = new SiGMLDocToGSiGMLSigns(this.hstohConverter, this.htohConverter, this.htosConverter, this.getSignsTextGen(), baseuri, sigml);
            signs = sgen.getSigns();
        }
        catch (SiGMLDocToGSiGMLSigns.SignGenException sgx) {
            System.out.println("signsForSiGML(): " + sgx.getMessage());
        }
        return signs;
    }

    public HNSSign[] gesturalSiGMLToHNS(String gsigml) throws GToHNSSignSiGML.GToHNSException {
        return this.gSiGMLConvertToHNS(gsigml);
    }

    protected native void noteSIServiceStarted();

    protected native void noteSIServiceStopped();

    protected native void acceptSiGML(String[] var1);

    public void bytesBlockStreamStarted() {
        this.noteSIServiceStarted();
    }

    public void bytesBlockStreamStopped() {
        inputIsActive = false;
        this.noteSIServiceStopped();
        this.inputServer = null;
        this.broadcastInputServer = null;
        this.inputKind = -1;
        this.inputPort = 0;
        this.stopPort = 0;
        if (this.logger != null) {
            this.logger.closeLogFile();
            this.logger = null;
        }
    }

    public void acceptBytesBlock(byte[] bb) {
        this.doAcceptInputBlock(bb);
    }

    public synchronized void stringStreamStarted() {
        this.noteSIServiceStarted();
    }

    public synchronized void stringStreamStopped() {
        inputIsActive = false;
        this.noteSIServiceStopped();
        this.inputServer = null;
        this.broadcastInputServer = null;
        this.inputKind = -1;
        this.inputPort = 0;
        this.stopPort = 0;
        if (this.logger != null) {
            this.logger.closeLogFile();
            this.logger = null;
        }
    }

    public synchronized void acceptString(String s) {
        this.doAcceptInputString(s);
    }

    protected XmlElementTextGen getSignsTextGen() {
        if (this.signsTextGen == null) {
            try {
                this.signsTextGen = new XmlElementTextGen(false, "utf-8", false);
            }
            catch (TransformerConfigurationException tcx) {
                System.out.println("SiGMLInLib.getSignsTextGen(): " + tcx);
            }
        }
        return this.signsTextGen;
    }

    protected String doStartService(int informat, int inport, int stopport) {
        if (inputIsActive) {
            return "SiGML input is already active.";
        }
        inputIsActive = true;
        String error = null;
        if (0 <= this.inputKind) {
            error = "server (kind=" + this.inputKind + ") already running";
        } else if (SIDefs.isBroadcastSiGML(informat)) {
            int bsbaseport = SIDefs.inPort(3, inport);
            String logfile = null;
            this.logger = new Logger(logfile);
            this.broadcastInputServer = new BroadcastSiGMLInputService(this, this.logger, bsbaseport);
            this.inputKind = 3;
            this.inputPort = bsbaseport;
            this.stopPort = -1;
            this.inputServer = null;
        } else {
            int spt;
            int inpt;
            boolean fmtok = SIDefs.isValid(informat);
            error = this.startErrorCheck(fmtok, inpt = SIDefs.inPort(informat, inport), spt = SIDefs.stopPort(inport, stopport));
            if (error == null) {
                try {
                    this.inputServer = new SiGMLInputService(true, inpt, spt, this);
                    this.inputKind = informat;
                    this.inputPort = inpt;
                    this.stopPort = spt;
                    this.broadcastInputServer = null;
                }
                catch (IOException iox) {
                    error = "input setup error: " + iox.getMessage();
                }
            }
        }
        return SiGMLInLib.unNullify(error);
    }

    protected String startErrorCheck(boolean fmtok, int inpt, int spt) {
        String error = null;
        if (!fmtok) {
            error = "unknown input format";
        } else if (inpt < 0) {
            error = "invalid input port";
        } else if (spt < 0) {
            error = "invalid stop port";
        }
        return error;
    }

    protected void doStopService() {
        if (0 <= this.inputKind) {
            if (SIDefs.isBroadcastSiGML(this.inputKind)) {
                this.broadcastInputServer.kill();
            } else {
                SiGMLInputServiceStopper siGMLInputServiceStopper = new SiGMLInputServiceStopper(this.stopPort);
            }
        }
    }

    protected void doAcceptInputBlock(byte[] bb) {
        try {
            XMLBytesDecoder xbd = new XMLBytesDecoder(bb);
            this.doAcceptInputString(xbd.getXMLString());
        }
        catch (Exception e) {
            this.reportException("SiGMLInLib Input Failure", e);
        }
    }

    protected void doAcceptInputString(String s) {
        try {
            if (SIDefs.isSiGML(this.inputKind)) {
                this.doAcceptSiGML(s);
            } else if (SIDefs.isHNST(this.inputKind)) {
                this.doAcceptHNS(s);
            } else if (SIDefs.isHNS(this.inputKind)) {
                this.doAcceptHNS(s);
            } else if (SIDefs.isBroadcastSiGML(this.inputKind)) {
                this.doAcceptBroadcastSiGML(s);
            }
        }
        catch (Exception e) {
            this.reportException("SiGMLInLib Input Failure", e);
        }
    }

    protected void doAcceptSiGML(String sigml) {
        String[] result = null;
        boolean issplus = false;
        int i = 0;
        if (sigml.startsWith("<?xml")) {
            i = sigml.indexOf("?>");
        }
        if (0 <= i && 0 <= (i = sigml.indexOf("<", i))) {
            issplus = sigml.substring(i).startsWith("<SiGMLPlus");
        }
        if (issplus) {
            String[] spinfo = new String[]{sigml, sigml, "0", ""};
            result = spinfo;
        } else {
            result = this.sigmlConvertHNSToGestural(sigml, "sigml");
        }
        this.acceptSiGML(result);
    }

    protected void doAcceptBroadcastSiGML(String bsigml) {
        String hdr = HSDocParameters.getSiGMLHeader("sigmlsection");
        String[] bsinfo = new String[]{"<sigmlsection/>", hdr + bsigml, "0", ""};
        this.acceptSiGML(bsinfo);
    }

    protected void doAcceptHNS(String hns) {
        String[] result = this.sigmlGenFromHNSText(hns, this.inputKind);
        this.acceptSiGML(result);
    }

    protected String[] convertSiGMLHNSSignToGestural(String hnssignel) {
        String sigml = null;
        String error = null;
        HNSSign hsign = this.hstohConverter.convert(hnssignel);
        try {
            String hml = this.htohConverter.hmlSignText(hsign);
            sigml = this.htosConverter.sigmlSignTextForHML(hml);
        }
        catch (HNSToHML.HNSToHMLException hhx) {
            error = "HNSToHML error: " + hhx.getMessage();
        }
        catch (HMLToSiGML.HMLToSiGMLException hsx) {
            error = "HMLToSiGML error: " + hsx.getMessage();
        }
        String[] result = new String[]{sigml, error};
        return SiGMLInLib.unNullify(result);
    }

    protected String[] sigmlGenFromHNSText(String hns, int hkind) {
        HNSInputAsSignSequence hnsin = SIDefs.isHNST(hkind) ? new HNSTAsSignSequence(hns) : new HNSStdAsSignSequence(hns);
        SiGMLDocsFromHNSSource sdocsgen = new SiGMLDocsFromHNSSource(this.htohConverter, this.htosConverter, hnsin);
        String hnssignsdoc = sdocsgen.getHNSSignsDoc();
        String gsignsdoc = sdocsgen.getGesturalSignsDoc();
        String errortxt = hnsin.sigmlErrorText();
        int nerrs = hnsin.sigmlInputErrorCount();
        int gerrs = sdocsgen.getGesturalErrorCount();
        if (gerrs != 0) {
            nerrs += gerrs;
            errortxt = errortxt + sdocsgen.getGesturalErrorText();
        }
        String hml = sdocsgen.getHMLDoc();
        String[] result = new String[]{hnssignsdoc, gsignsdoc, "" + nerrs, errortxt, hml};
        return SiGMLInLib.unNullify(result);
    }

    public void setEnabledLogHML(boolean enabled) {
        this.doLogHML = enabled;
    }

    protected String[] sigmlConvertHNSToGestural(String sigml, String doceltype) {
        String gsigml = null;
        String gerrtxt = null;
        int gerrs = 0;
        try {
            SiGMLDocHNSToGestural scnvt = new SiGMLDocHNSToGestural(this.hstohConverter, this.htohConverter, this.htosConverter, sigml, doceltype, this.doLogHML);
            gsigml = scnvt.getGesturalSiGMLDoc();
            gerrtxt = scnvt.getGesturalErrorText();
            gerrs = scnvt.getGesturalErrorCount();
        }
        catch (SiGMLDocHNSToGestural.SiGMLConvertException scx) {
            gerrs = 1;
            gerrtxt = scx.getMessage();
        }
        if (gsigml == null) {
            String gshead = HSDocParameters.getSiGMLPrefix(doceltype);
            String gstail = HSDocParameters.getSiGMLSuffix(doceltype);
            gsigml = gshead + gstail;
        }
        String[] result = new String[]{sigml, gsigml, "" + gerrs, gerrtxt};
        return SiGMLInLib.unNullify(result);
    }

    protected HNSSign[] gSiGMLConvertToHNS(String gsigml) throws GToHNSSignSiGML.GToHNSException {
        XMLChildElementsExtractor cex = new XMLChildElementsExtractor(gsigml, "hamgestural_sign", false, (CleanerEntityResolver)new SiGMLResolver());
        String[] gsigns = cex.getElementStrings();
        int N = gsigns.length;
        HNSSign[] hsigns = new HNSSign[N];
        for (int i = 0; i != N; ++i) {
            String hnsel = this.gtohConverter.hnsSignTextForGSiGML(gsigns[i]);
            hsigns[i] = this.hstohConverter.convert(hnsel);
        }
        return hsigns;
    }

    protected static String unNullify(String s) {
        return s == null ? "" : s;
    }

    protected static String[] unNullify(String[] ss) {
        int N = ss.length;
        for (int i = 0; i != N; ++i) {
            ss[i] = SiGMLInLib.unNullify(ss[i]);
        }
        return ss;
    }

    protected void reportException(String title, Exception e) {
        String msg = e.getMessage();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            sw.close();
            msg = sw.toString();
        }
        catch (IOException iox) {
            // empty catch block
        }
        this.displayMessage(title, msg);
    }

    protected void displayMessage(String title, String msg) {
        System.err.println(title + ":");
        System.err.println(msg);
        JOptionPane.showMessageDialog(null, msg, title, 0);
    }
}

