/*
 * Decompiled with CFR 0.152.
 */
package sigmlinlib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import sigmlinlib.SiGMLInLib;
import util.StringUtils;
import xml.XMLBytesDecoder;

public class HToGSiGMLConvert {
    private static final String EOL = StringUtils.EOL;

    public static void main(String[] args) {
        if (args.length < 1) {
            HToGSiGMLConvert.usageAbort("no SiGML file specified");
        } else if (2 < args.length) {
            HToGSiGMLConvert.usageAbort("too many arguments");
        }
        File sfile = HToGSiGMLConvert.getSiGMLFile(args[0]);
        if (sfile == null) {
            HToGSiGMLConvert.usageAbort("Missing input file: " + args[0]);
        }
        File gsfile = HToGSiGMLConvert.getResultFile(args.length == 2 ? args[1] : null, sfile);
        try {
            boolean htogok;
            byte[] sbytes = HToGSiGMLConvert.readFileBytes(sfile);
            XMLBytesDecoder xbd = new XMLBytesDecoder(sbytes);
            String sigml = xbd.getXMLString();
            SiGMLInLib silib = new SiGMLInLib();
            String[] sresult = silib.sigmlSignsToGestural(sigml);
            String gsigml = sresult[1];
            String err = sresult[3];
            String ecount = sresult[2];
            boolean bl = htogok = err == null ? true : err.equals("");
            if (!htogok) {
                HToGSiGMLConvert.report(err, ecount);
            }
            HToGSiGMLConvert.writeFile(gsfile, gsigml);
            System.out.println("#### " + sfile + ": conversion done.");
        }
        catch (IOException iox) {
            HToGSiGMLConvert.abort(iox.getMessage());
        }
    }

    private static byte[] readFileBytes(String path) throws IOException {
        File f = new File(path);
        return HToGSiGMLConvert.readFileBytes(f);
    }

    private static File getSiGMLFile(String fname) {
        File inf = null;
        String[] suffices = new String[]{"", ".sigml", ".xml"};
        int N = suffices.length;
        int i = 0;
        int ii = N;
        while (i != ii) {
            inf = new File(fname + suffices[i]);
            if (inf.exists()) {
                ii = i;
                continue;
            }
            ++i;
        }
        return i == N ? null : inf;
    }

    private static File getResultFile(String fname, File infile) {
        File rfile = null;
        if (fname != null) {
            rfile = new File(fname);
        } else {
            String stem = infile.getName();
            int N = stem.length();
            if (stem.endsWith(".sigml")) {
                stem = stem.substring(0, N - ".sigml".length());
            } else if (stem.endsWith(".xml")) {
                stem = stem.substring(0, N - ".xml".length());
            }
            rfile = new File(infile.getParentFile(), stem + "_g.sigml");
        }
        return rfile;
    }

    private static byte[] readFileBytes(File f) throws IOException {
        int N = (int)f.length();
        FileInputStream ins = new FileInputStream(f);
        BufferedInputStream bins = new BufferedInputStream(ins);
        byte[] fbytes = new byte[N];
        bins.read(fbytes);
        bins.close();
        return fbytes;
    }

    private static void writeFile(File path, String txt) throws IOException {
        PrintWriter pwrtr = new PrintWriter(new FileWriter(path));
        pwrtr.print(txt);
        pwrtr.flush();
        pwrtr.close();
    }

    private static void usageAbort(String msg) {
        System.out.println("usage:  java sigmlinlib.HToGSiGMLConvert infile [outfile]");
        HToGSiGMLConvert.abort(msg);
    }

    private static void abort(String msg) {
        HToGSiGMLConvert.report(msg);
        System.exit(1);
    }

    private static void report(String msg) {
        System.out.println("H-to-G SiGML converter failure: ");
        System.out.println(msg);
    }

    private static void report(String msg, String ecount) throws IOException {
        String msgc = msg + " Error-Count=" + ecount + EOL;
        HToGSiGMLConvert.report(msgc);
    }
}

