/*
 * Decompiled with CFR 0.152.
 */
package sigmlinlib;

import hnscnvt.HNSInputToHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import sigmlinlib.SiGMLInLib;
import util.HNSBytesInputConverter;
import util.StringUtils;

public class HNSSignConvert {
    private static final String EOL = StringUtils.EOL;

    public static void main(String[] args) {
        if (args.length < 1) {
            HNSSignConvert.abort("no HNS file specified");
        } else if (2 < args.length) {
            HNSSignConvert.abort("too many arguments");
        }
        HNSInputToHandler.HNS_INPUT_IS_MAC_ROMAN = true;
        boolean inHNST = true;
        boolean doGSiGML = false;
        boolean doHML = false;
        boolean doHNSError = false;
        if (args.length == 2) {
            char[] opts = args[1].toCharArray();
            if (opts.length < 2) {
                HNSSignConvert.abort("options string too short");
            }
            if (opts[0] != '-') {
                HNSSignConvert.abort("options string must start with '-'");
            }
            for (int i = 1; i != opts.length; ++i) {
                char och = opts[i];
                if (och == 'e') {
                    doHNSError = true;
                    continue;
                }
                if (och == 'g') {
                    doGSiGML = true;
                    continue;
                }
                if (och == 'h') {
                    doGSiGML = false;
                    continue;
                }
                if (och == 't') {
                    inHNST = true;
                    continue;
                }
                if (och == 's') {
                    inHNST = false;
                    continue;
                }
                if (och == 'i') {
                    doHML = true;
                    continue;
                }
                HNSSignConvert.abort("valid options characters: e g t s i");
            }
            doHNSError &= !inHNST;
        }
        String hfile = args[0];
        String hnssfx = inHNST ? ".hnst" : ".hns";
        String hmlsfx = ".hml";
        String hsigmlsfx = ".sigml";
        String gsigmlsfx = "_g.sigml";
        String ehnssfx = "_e.hns";
        String pemsfx = "_emsg.txt";
        if (hfile.endsWith(hnssfx) | hfile.endsWith(hnssfx.toUpperCase())) {
            hfile = hfile.substring(0, hfile.length() - hnssfx.length());
        }
        try {
            boolean htosok;
            byte[] hnsbytes = HNSSignConvert.readFileBytes(hfile + hnssfx);
            HNSBytesInputConverter hnsucvt = new HNSBytesInputConverter(hnsbytes);
            String hns = hnsucvt.getInputString();
            long tpre = System.currentTimeMillis();
            SiGMLInLib silib = new SiGMLInLib();
            String[] sresult = inHNST ? silib.hnstSignsToSiGML(hns) : silib.hnsStdSignsToSiGML(hns);
            String hsigml = sresult[0];
            String gsigml = sresult[1];
            String hml = sresult[sresult.length - 1];
            String err = sresult[3];
            String ecount = sresult[2];
            long tpost = System.currentTimeMillis();
            System.out.println("convert time: " + (tpost - tpre) + " ms.");
            boolean bl = htosok = err == null ? true : err.equals("");
            if (!htosok) {
                HNSSignConvert.report(hfile + "_emsg.txt", err, ecount);
            }
            HNSSignConvert.writeFile(hfile + ".sigml", hsigml);
            if (doHML) {
                HNSSignConvert.writeFile(hfile + ".hml", hml);
            }
            if (doGSiGML) {
                HNSSignConvert.writeFile(hfile + "_g.sigml", gsigml);
            }
            if (doHNSError & !htosok) {
                HNSSignConvert.generateErrorHNSFile(err, hfile + hnssfx, hfile + "_e.hns");
            }
            System.out.println("####  " + hfile + ": conversion done.");
        }
        catch (IOException iox) {
            HNSSignConvert.abort(iox.getMessage());
        }
    }

    private static void checkH2G(SiGMLInLib silib, String hsigml) {
        String[] h2g = silib.sigmlSignsToGestural(hsigml);
        System.out.println("####  checkH2G:");
        System.out.println("####  .... err:" + h2g[3]);
        System.out.println("####  .... result-text ....");
        System.out.println(h2g[1]);
    }

    private static void generateErrorHNSFile(String emsg, String hpath, String epath) throws IOException {
        System.out.println("Generating failed-HNS file.");
        String[] eindices = HNSSignConvert.getErrorIndexStrings(emsg);
        int N = eindices.length;
        String[] hns = HNSSignConvert.readFileLines(hpath);
        String[] ehns = new String[N];
        for (int i = 0; i != N; ++i) {
            int j = Integer.parseInt(eindices[i]);
            ehns[i] = hns[j];
        }
        HNSSignConvert.writeHNSFile(epath, ehns);
    }

    private static String[] getErrorIndexStrings(String emsg) {
        ArrayList<String> elist = new ArrayList<String>();
        int j = 0;
        int i = emsg.indexOf("HNS-Index", j);
        int n = 0;
        while (j <= i & n < 200) {
            ++n;
            i = emsg.indexOf("=", i) + 1;
            j = emsg.indexOf(",", i);
            String index = emsg.substring(i, j);
            elist.add(index);
            i = emsg.indexOf("HNS-Index", j);
        }
        int N = elist.size();
        String[] eindices = new String[N];
        elist.toArray(eindices);
        elist.clear();
        return eindices;
    }

    private static byte[] readFileBytes(String path) throws IOException {
        File f = new File(path);
        int N = (int)f.length();
        FileInputStream ins = new FileInputStream(f);
        BufferedInputStream bins = new BufferedInputStream(ins);
        byte[] fbytes = new byte[N];
        bins.read(fbytes);
        bins.close();
        return fbytes;
    }

    private static String readFile(String path) throws IOException {
        FileInputStream ins = new FileInputStream(path);
        BufferedReader brdr = new BufferedReader(new InputStreamReader((InputStream)ins, "ISO-8859-1"));
        StringBuilder sbuf = new StringBuilder(2048);
        String ln = brdr.readLine();
        while (ln != null) {
            sbuf.append(ln).append(EOL);
            ln = brdr.readLine();
        }
        brdr.close();
        return sbuf.toString();
    }

    private static String[] readFileLines(String path) throws IOException {
        FileInputStream ins = new FileInputStream(path);
        BufferedReader brdr = new BufferedReader(new InputStreamReader((InputStream)ins, "ISO-8859-1"));
        ArrayList<String> list = new ArrayList<String>(1024);
        String ln = brdr.readLine();
        while (ln != null) {
            list.add(ln);
            ln = brdr.readLine();
        }
        brdr.close();
        int N = list.size();
        String[] lines = new String[N];
        list.toArray(lines);
        list.clear();
        return lines;
    }

    private static void writeHNSFile(String path, String[] lines) throws IOException {
        FileOutputStream os = new FileOutputStream(path);
        OutputStreamWriter wrtr = new OutputStreamWriter((OutputStream)os, "ISO-8859-1");
        BufferedWriter bwrtr = new BufferedWriter(wrtr);
        for (int i = 0; i != lines.length; ++i) {
            bwrtr.write(lines[i]);
            bwrtr.write(EOL);
        }
        bwrtr.flush();
        bwrtr.close();
    }

    private static void writeHNSFile(String path, String txt) throws IOException {
        FileOutputStream os = new FileOutputStream(path);
        OutputStreamWriter wrtr = new OutputStreamWriter((OutputStream)os, "ISO-8859-1");
        BufferedWriter bwrtr = new BufferedWriter(wrtr);
        bwrtr.write(txt);
        bwrtr.flush();
        bwrtr.close();
    }

    private static void writeFile(String path, String txt) throws IOException {
        PrintWriter pwrtr = new PrintWriter(new FileWriter(path));
        pwrtr.print(txt);
        pwrtr.flush();
        pwrtr.close();
    }

    private static void abort(String msg) {
        HNSSignConvert.report(msg);
        System.exit(1);
    }

    private static void report(String msg) {
        System.out.println("HNS-to-SiGML converter failure: ");
        System.out.println(msg);
    }

    private static void report(String epath, String msg, String ecount) throws IOException {
        String msgc = msg + "HNS-Parse-Error-Count=" + ecount + EOL;
        HNSSignConvert.writeFile(epath, msgc);
        HNSSignConvert.report(msgc);
    }
}

