/*
 * Decompiled with CFR 0.152.
 */
package sigmlinlib;

import broadcast.SiGMLSegmentSynchAcceptor;
import broadcast.SiGMLSegmentSynchDelivery;
import broadcast.TimeKeeper;
import sigmlinlib.StringStreamHandler;
import util.Logging;

public class BroadcastSiGMLInputService
implements SiGMLSegmentSynchAcceptor {
    protected Logging logger;
    protected SiGMLSegmentSynchDelivery ssegReceiver;
    protected TimeKeeper timer;
    protected StringStreamHandler target;
    protected Thread consumerThread;
    protected ProdConsSynch synch;
    protected boolean killed;
    protected boolean segmentAccepted;
    protected boolean starterAccepted;
    protected boolean terminatorAccepted;
    protected String segment;
    protected long terminatorClock;

    public BroadcastSiGMLInputService(StringStreamHandler sshdlr, Logging lggr) {
        this(sshdlr, lggr, -1);
    }

    public BroadcastSiGMLInputService(StringStreamHandler sshdlr, Logging lggr, int bsbaseport) {
        this.logger = lggr;
        this.ssegReceiver = new SiGMLSegmentSynchDelivery(this, this.logger, bsbaseport);
        this.killed = false;
        this.segmentAccepted = false;
        this.terminatorAccepted = false;
        this.segment = null;
        this.synch = new ProdConsSynch();
        this.target = sshdlr;
        this.consumerThread = new Thread(){

            public void run() {
                BroadcastSiGMLInputService.this.runConsumer();
            }
        };
        this.consumerThread.start();
    }

    public void acceptErrorReport(String msg) {
        String pfx = "BroadcastSiGMLInputService: ";
        String fullmsg = pfx + msg;
        this.logger.logMsg(fullmsg);
        System.out.println(fullmsg);
    }

    public void setTimer(TimeKeeper timer) {
        this.timer = timer;
    }

    public void acceptStarter() {
        this.synch.waitToProduce();
        this.starterAccepted = true;
        this.synch.notifyProduceDone();
    }

    public void acceptTerminator(long tclk) {
        this.synch.waitToProduce();
        this.terminatorClock = tclk;
        this.terminatorAccepted = true;
        this.synch.notifyProduceDone();
    }

    public void acceptSegment(String sgmt) {
        this.synch.waitToProduce();
        this.segment = sgmt;
        this.segmentAccepted = true;
        this.synch.notifyProduceDone();
    }

    public void kill() {
        this.ssegReceiver.kill();
    }

    protected void runConsumer() {
        while (!this.killed) {
            this.synch.waitToConsume();
            if (this.starterAccepted) {
                this.doAcceptStarter();
                this.synch.notifyConsumeDone();
                continue;
            }
            if (this.segmentAccepted) {
                this.doAcceptSegment();
                this.synch.notifyConsumeDone();
                continue;
            }
            if (this.terminatorAccepted) {
                this.killed = true;
                this.terminatorAccepted = false;
                this.synch.notifyConsumeDone();
                continue;
            }
            if (!this.killed) continue;
            this.synch.notifyConsumeDone();
        }
        this.doKill();
    }

    public void doAcceptStarter() {
        this.target.stringStreamStarted();
        this.starterAccepted = false;
    }

    protected void doAcceptSegment() {
        this.target.acceptString(this.segment);
        this.segmentAccepted = false;
    }

    protected void doKill() {
        this.target.stringStreamStopped();
    }

    protected static class ProdConsSynch {
        private boolean produceOK = true;
        private boolean consumePending = false;

        public synchronized void waitToProduce() {
            while (!this.produceOK) {
                try {
                    this.wait();
                }
                catch (InterruptedException ix) {}
            }
            this.produceOK = false;
            while (this.consumePending) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void notifyProduceDone() {
            this.consumePending = true;
            this.notifyAll();
            this.produceOK = true;
            this.notifyAll();
        }

        public synchronized void waitToConsume() {
            while (!this.consumePending) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void notifyConsumeDone() {
            this.consumePending = false;
            this.notifyAll();
        }
    }
}

