/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen.xslth4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.StringUtils;

public final class H2SAccess {
    private static final String PKG_PREFIX = "sigmlgen/xslth4/";
    private static final String QUOTE = "[\"']";
    private static final String NO_QUOTE = "[^\"']";
    private static final String NEXT_SLASH = "[^/]*/";
    private static final String NEXT_R_ANGLE = "[^>]*>";
    private static final Pattern XFORM_BEGIN = Pattern.compile("<xsl:transform[^>]*>");
    private static final Pattern XFORM_END = Pattern.compile("</xsl:transform[^>]*>");
    private static final Pattern XSL_INCLUDE = Pattern.compile("<xsl:include\\s+href=[\"']([^\"']+\\.xsl)[\"'][^/]*/[^>]*>");

    public static final Reader xsltReader(String relpath) {
        return new StringReader(H2SAccess.xsltText(relpath));
    }

    public static final String xsltText(String relpath) {
        String text = null;
        if (relpath.startsWith(PKG_PREFIX)) {
            String xslf = relpath.substring(PKG_PREFIX.length());
            StringBuilder sbuf = new StringBuilder(110592);
            H2SAccess.appendFullXslt(xslf, 0, sbuf);
            text = sbuf.toString();
            sbuf.setLength(0);
            sbuf.trimToSize();
        } else {
            System.out.println("####  H2SAccess: non-local path: " + relpath + ".");
        }
        return text;
    }

    private static final void appendFullXslt(String xname, int level, StringBuilder sbuf) {
        String xtext = H2SAccess.readXsltText(xname);
        if (level != 0) {
            xtext = H2SAccess.stripTransformWrapper(xtext);
        }
        Matcher mtchxi = XSL_INCLUDE.matcher(xtext);
        int i = 0;
        while (mtchxi.find(i)) {
            sbuf.append(xtext.substring(i, mtchxi.start()));
            i = mtchxi.end();
            String XSLT_NAME = mtchxi.group(1);
            sbuf.append("<!--%%%%  " + XSLT_NAME + " BEGIN  %%%%-->" + StringUtils.EOL);
            H2SAccess.appendFullXslt(XSLT_NAME, level + 1, sbuf);
            sbuf.append("<!--%%%%  " + XSLT_NAME + " END  %%%%-->" + StringUtils.EOL);
        }
        sbuf.append(xtext.substring(i));
    }

    private static String readXsltText(String xname) {
        String xtxt = null;
        InputStream xins = H2SAccess.class.getResourceAsStream(xname);
        try {
            if (xins == null) {
                throw new IOException("Invalid name: " + xname + ".");
            }
            xtxt = StringUtils.readText(xins);
        }
        catch (IOException iox) {
            System.out.println("####  XSLT document failure: " + iox);
        }
        return xtxt;
    }

    private static final String stripTransformWrapper(String xslt) {
        Matcher mbegin = XFORM_BEGIN.matcher(xslt);
        Matcher mend = XFORM_END.matcher(xslt);
        mbegin.find();
        mend.find();
        return xslt.substring(mbegin.end(), mend.start());
    }
}

