/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen.playerctrl;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sigmlgen.playerctrl.AmbientMotionFlags;
import sigmlgen.playerctrl.CameraSettings;

public class PlayerSettings {
    private CameraSettings cam = null;
    private AmbientMotionFlags ambients = null;

    public PlayerSettings(Element psel) {
        for (Node nd = psel.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (nd.getNodeType() != 1) continue;
            String EL_TAG = nd.getNodeName();
            if (EL_TAG == "camera_location") {
                this.setCamera((Element)nd);
                continue;
            }
            if (EL_TAG != "ambient_motions") continue;
            this.setAmbients((Element)nd);
        }
    }

    public CameraSettings getCameraSettings() {
        return this.cam;
    }

    public AmbientMotionFlags getAmbients() {
        return this.ambients;
    }

    private void setCamera(Element cel) {
        float cx = Float.parseFloat(cel.getAttribute("cx"));
        float cy = Float.parseFloat(cel.getAttribute("cy"));
        float r = Float.parseFloat(cel.getAttribute("r"));
        float theta = Float.parseFloat(cel.getAttribute("theta"));
        float phi = Float.parseFloat(cel.getAttribute("phi"));
        float fov = Float.parseFloat(cel.getAttribute("fov"));
        this.cam = new CameraSettings(cx, cy, r, theta, phi, fov);
    }

    private void setAmbients(Element amel) {
        boolean bodyon = amel.getAttribute("body").equals("ON");
        boolean headon = amel.getAttribute("head").equals("ON");
        boolean blinkon = amel.getAttribute("blink").equals("ON");
        this.ambients = new AmbientMotionFlags(bodyon, headon, blinkon);
    }
}

