/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSSignElementToHNS;
import hnscnvt.HNSToHML;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.w3c.dom.Element;
import sigmlgen.GSiGMLSign;
import sigmlgen.SiGMLDocToGSiGMLSigns;
import util.NetUtils;
import xml.XmlElementTextGen;

public class SigningRefProcessor {
    protected GSiGMLSign[] gsSigns;

    public SigningRefProcessor(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, URI BASE, Element S_REF) {
        GSiGMLSign[] GS_EMPTY = new GSiGMLSign[]{};
        this.gsSigns = GS_EMPTY;
        String URI_STR = S_REF.getAttribute("uri");
        String format = S_REF.getAttribute("format");
        String compressed = S_REF.getAttribute("compressed");
        if (!format.equals("SiGML")) {
            System.out.println("<signing_ref> format=" + format + " is unsupported;  URI: " + URI_STR);
        } else if (!compressed.equals("no")) {
            System.out.println("<signing_ref> compressed=" + compressed + " is unsupported;  URI: " + URI_STR);
        } else {
            URI SIGML_URI = NetUtils.getResolvedURI(BASE, URI_STR);
            System.out.println("####  <signing_ref> URI: " + (SIGML_URI == null ? "[null]" : SIGML_URI.toASCIIString()));
            if (SIGML_URI != null) {
                this.processSiGMLURI(hstoh, htoh, htos, xtgen, SIGML_URI, URI_STR);
            }
        }
    }

    public GSiGMLSign[] getSigns() {
        return this.gsSigns;
    }

    protected void processSiGMLURI(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, URI SIGML_URI, String URI_STR) {
        try {
            URL sigmlurl = SIGML_URI.toURL();
            InputStream ins = sigmlurl.openStream();
            SiGMLDocToGSiGMLSigns sdtogs = new SiGMLDocToGSiGMLSigns(hstoh, htoh, htos, xtgen, SIGML_URI, ins);
            this.gsSigns = sdtogs.getSigns();
        }
        catch (IOException iox) {
            this.reportException(iox, URI_STR);
        }
        catch (SiGMLDocToGSiGMLSigns.SignGenException sgx) {
            this.reportException(sgx, URI_STR);
        }
    }

    protected void reportException(Exception x, String uri) {
        System.out.println("Bad <signing_ref> URI: " + uri + " ...");
        System.out.println(x);
    }
}

