/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSInputAsSignSequence;
import hnscnvt.HNSSign;
import hnscnvt.HNSToHML;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLTagDefs;
import util.StringUtils;

public class SiGMLDocsFromHNSSource {
    protected static final String EOL = StringUtils.EOL;
    protected HNSToHML htohConverter;
    protected HMLToSiGML htosConverter;
    protected HNSSign[] hnsSigns;
    protected String[] hnsSignEls;
    protected String[] glosses;
    protected String inErrorText;
    protected int inErrorCount;
    protected String hnsSignsDocText;
    protected String gesturalSignsDocText;
    protected String hmlDocText;
    protected String gesturalErrorText;
    protected int gesturalErrorCount;
    private static boolean SUPPRESS_GSIGML_IF_ERRORS = false;
    protected transient String hmlSign;
    protected transient String gesturalSign;
    protected transient String gSignError;

    public SiGMLDocsFromHNSSource(HNSToHML htoh, HMLToSiGML htos, HNSInputAsSignSequence hnsin) {
        this.htohConverter = htoh;
        this.htosConverter = htos;
        this.hnsSigns = hnsin.hnsSignSequence();
        this.hnsSignEls = hnsin.sigmlHNSSigns();
        this.glosses = hnsin.signGlosses();
        this.inErrorText = hnsin.sigmlErrorText();
        this.inErrorCount = hnsin.sigmlInputErrorCount();
        this.makeHNSSignsDoc();
        this.gesturalErrorText = "";
        this.gesturalErrorCount = 0;
        this.makeGesturalSignsDoc();
    }

    public String getHNSSignsDoc() {
        return this.hnsSignsDocText;
    }

    public String getHMLDoc() {
        return this.hmlDocText;
    }

    public String getGesturalSignsDoc() {
        return this.gesturalSignsDocText;
    }

    public String getGesturalErrorText() {
        return this.gesturalErrorText;
    }

    public int getGesturalErrorCount() {
        return this.gesturalErrorCount;
    }

    protected void makeHNSSignsDoc() {
        this.hnsSignsDocText = this.makeSiGMLDocText(this.hnsSignEls);
    }

    protected void makeGesturalSignsDoc() {
        String[] hsigns = new String[]{};
        String[] gsigns = new String[]{};
        if (this.inErrorCount == 0 || !SUPPRESS_GSIGML_IF_ERRORS) {
            int N = this.hnsSigns.length;
            hsigns = new String[N];
            gsigns = new String[N];
            StringBuilder gerrs = new StringBuilder();
            String geheader = "####  Gestural-Convert errors ..." + EOL;
            for (int i = 0; i != N; ++i) {
                this.convertSignToGestural(this.hnsSigns[i]);
                hsigns[i] = this.hmlSign;
                gsigns[i] = this.gesturalSign;
                if (this.gSignError == null) continue;
                String glss = this.glosses[i];
                if (hsigns[i] == null) {
                    hsigns[i] = SiGMLTagDefs.emptyHMLSignText(glss);
                }
                gsigns[i] = SiGMLTagDefs.emptyGesturalSignText(glss);
                if (this.gesturalErrorCount == 0) {
                    gerrs.append(geheader);
                }
                ++this.gesturalErrorCount;
                gerrs.append("HNS-Index=").append(i).append(", Gloss=").append(this.glosses[i]).append(':').append(EOL).append(this.gSignError).append(EOL);
            }
            if (this.gesturalErrorCount != 0) {
                if (SUPPRESS_GSIGML_IF_ERRORS) {
                    gsigns = new String[]{};
                }
                this.gesturalErrorText = gerrs.toString();
                gerrs.setLength(0);
                gerrs = null;
            }
        }
        this.hmlDocText = this.makeHMLDocText(hsigns);
        this.gesturalSignsDocText = this.makeSiGMLDocText(gsigns);
    }

    protected String makeSiGMLDocText(String[] signs) {
        String pfx = HSDocParameters.STD_SIGML_PREFIX;
        String sfx = HSDocParameters.STD_SIGML_SUFFIX;
        String doctext = null;
        if (signs == null) {
            doctext = pfx + sfx;
        } else {
            int slen = pfx.length() + sfx.length();
            int N = signs.length;
            for (int i = 0; i != N; ++i) {
                if (signs[i] == null) continue;
                slen += signs[i].length();
            }
            StringBuilder sbuf = new StringBuilder(slen);
            sbuf.append(pfx);
            for (int i = 0; i != N; ++i) {
                if (i != 0) {
                    sbuf.append(EOL);
                }
                sbuf.append(signs[i]);
            }
            sbuf.append(sfx);
            doctext = sbuf.toString();
            sbuf.setLength(0);
        }
        return doctext;
    }

    protected String makeHMLDocText(String[] hsigns) {
        String pfx = HSDocParameters.STD_HML_PREFIX;
        String sfx = HSDocParameters.STD_HML_SUFFIX;
        String hdoctext = null;
        if (hsigns == null) {
            hdoctext = pfx + sfx;
        } else {
            int slen = pfx.length() + sfx.length();
            int N = hsigns.length;
            for (int i = 0; i != N; ++i) {
                if (hsigns[i] == null) continue;
                slen += hsigns[i].length();
            }
            StringBuilder sbuf = new StringBuilder(slen);
            sbuf.append(pfx);
            for (int i = 0; i != N; ++i) {
                if (i != 0) {
                    sbuf.append(EOL);
                }
                sbuf.append(hsigns[i]);
            }
            sbuf.append(sfx);
            hdoctext = sbuf.toString();
            sbuf.setLength(0);
        }
        return hdoctext;
    }

    protected void convertSignToGestural(HNSSign hsign) {
        this.hmlSign = null;
        this.gesturalSign = null;
        this.gSignError = null;
        try {
            String hml = this.htohConverter.hmlSignText(hsign);
            String gssign = this.htosConverter.sigmlSignTextForHML(hml);
            this.hmlSign = hml;
            this.gesturalSign = gssign;
        }
        catch (HNSToHML.HNSToHMLException hhx) {
            this.gSignError = "HNSToHML error: " + hhx.getMessage();
        }
        catch (HMLToSiGML.HMLToSiGMLException hsx) {
            this.gSignError = "HMLToSiGML error: " + hsx.getMessage();
        }
    }
}

