/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSSignElementToHNS;
import hnscnvt.HNSToHML;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sigmlgen.GSiGMLSign;
import sigmlgen.SiGMLChildNodesProcessor;
import sigmlgen.SiGMLResolver;
import util.NetUtils;
import xml.BasicSAXHandler;
import xml.XmlElementTextGen;

public class SiGMLDocToGSiGMLSigns {
    protected URI baseURI;
    protected HNSSignElementToHNS hstohConverter;
    protected HNSToHML htohConverter;
    protected HMLToSiGML htosConverter;
    protected XmlElementTextGen xmlTextGen;
    protected InputSource sigmlSource;
    protected DocumentBuilder docBuilder;
    protected Document sigmlDoc;
    protected Element sigmlElement;
    protected GSiGMLSign[] gsSigns;

    public SiGMLDocToGSiGMLSigns(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, String sigmltext) throws SignGenException {
        this(hstoh, htoh, htos, xtgen, null, sigmltext);
    }

    public SiGMLDocToGSiGMLSigns(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, URI base, String sigmltext) throws SignGenException {
        this.baseURI = base;
        this.setConverters(hstoh, htoh, htos, xtgen);
        this.makeSiGMLSourceFromString(sigmltext);
        this.processSiGMLSource();
    }

    public SiGMLDocToGSiGMLSigns(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, URI base, InputStream sigmlins) throws SignGenException {
        this.baseURI = base;
        this.setConverters(hstoh, htoh, htos, xtgen);
        this.makeSiGMLSourceFromStream(sigmlins);
        this.processSiGMLSource();
    }

    public GSiGMLSign[] getSigns() {
        return this.gsSigns;
    }

    protected void setConverters(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen) {
        this.hstohConverter = hstoh;
        this.htohConverter = htoh;
        this.htosConverter = htos;
        this.xmlTextGen = xtgen;
    }

    protected void makeSiGMLSourceFromString(String doctext) {
        StringReader srdr = new StringReader(doctext);
        this.sigmlSource = new InputSource(srdr);
    }

    protected void makeSiGMLSourceFromStream(InputStream docins) {
        this.sigmlSource = new InputSource(docins);
    }

    protected void processSiGMLSource() throws SignGenException {
        this.makeDocumentBuilder();
        this.buildSiGMLDocument();
        if (this.sigmlElement != null) {
            this.updateBaseURI();
            this.generateSignsData();
        }
    }

    protected void makeDocumentBuilder() throws SignGenException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcx) {
            this.fail("doc-builder", pcx);
        }
        this.docBuilder.setEntityResolver(new SiGMLResolver());
        this.docBuilder.setErrorHandler(new BasicSAXHandler(null));
    }

    protected void buildSiGMLDocument() throws SignGenException {
        try {
            this.sigmlDoc = this.docBuilder.parse(this.sigmlSource);
            this.sigmlElement = this.sigmlDoc.getDocumentElement();
        }
        catch (IOException iox) {
            this.fail("parse", iox);
        }
        catch (SAXException sx) {
            this.fail("parse", sx);
        }
    }

    protected void updateBaseURI() {
        Attr buattr = this.sigmlElement.getAttributeNode("base_uri");
        String docbase = buattr == null ? null : buattr.getValue();
        this.baseURI = NetUtils.getResolvedURI(this.baseURI, docbase);
        if (docbase != null) {
            System.out.println("####  SiGMLDoc, revised base URI: " + (this.baseURI == null ? "[null]" : this.baseURI.toASCIIString()));
        }
    }

    protected void generateSignsData() {
        NodeList children = this.sigmlElement.getChildNodes();
        SiGMLChildNodesProcessor scnprocessor = new SiGMLChildNodesProcessor(this.hstohConverter, this.htohConverter, this.htosConverter, this.xmlTextGen, this.baseURI, this.sigmlDoc, children);
        this.gsSigns = scnprocessor.getSigns();
    }

    protected void fail(String msg, Exception x) throws SignGenException {
        String fullmsg = "SiGMLDocToGSiGMLSigns: " + msg + ": " + x.getMessage();
        throw new SignGenException(fullmsg);
    }

    public static class SignGenException
    extends Exception {
        public SignGenException(String msg) {
            super(msg);
        }
    }
}

