/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSSign;
import hnscnvt.HNSSignElementToHNS;
import hnscnvt.HNSToHML;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLResolver;
import sigmlgen.SiGMLTagDefs;
import xml.BasicSAXHandler;
import xml.XmlElementTextGen;

public class SiGMLDocHNSToGestural {
    protected HNSSignElementToHNS hstohConverter;
    protected HNSToHML htohConverter;
    protected HMLToSiGML htosConverter;
    protected String sigmlDocText;
    protected String sigmlDocElementType;
    protected DocumentBuilder docBuilder;
    protected Document sigmlDoc;
    protected String gesturalSiGMLDocText;
    protected int gesturalErrorCount;
    protected String gesturalErrorText;
    private final boolean DO_SHOW_HML;
    protected transient Element gesturalSign;
    protected transient String gesturalSignError;
    protected transient String elText;
    protected transient String elTextError;

    public SiGMLDocHNSToGestural(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, String sigmltext) throws SiGMLConvertException {
        this(hstoh, htoh, htos, sigmltext, "sigml");
    }

    public SiGMLDocHNSToGestural(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, String sigmltext, String doceltype) throws SiGMLConvertException {
        this(hstoh, htoh, htos, sigmltext, doceltype, false);
    }

    public SiGMLDocHNSToGestural(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, String sigmltext, String doceltype, boolean loghml) throws SiGMLConvertException {
        this.hstohConverter = hstoh;
        this.htohConverter = htoh;
        this.htosConverter = htos;
        this.sigmlDocText = sigmltext;
        this.sigmlDocElementType = doceltype;
        this.DO_SHOW_HML = loghml;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcx) {
            this.fail("doc-builder", pcx);
        }
        this.docBuilder.setEntityResolver(new SiGMLResolver());
        this.docBuilder.setErrorHandler(new BasicSAXHandler(null));
        this.buildSiGMLDocument();
        this.doConvertSiGML();
    }

    public String getGesturalSiGMLDoc() {
        return this.gesturalSiGMLDocText;
    }

    public int getGesturalErrorCount() {
        return this.gesturalErrorCount;
    }

    public String getGesturalErrorText() {
        return this.gesturalErrorText;
    }

    protected void buildSiGMLDocument() throws SiGMLConvertException {
        String sigmltxt = this.sigmlDocText;
        String docelbegin = SiGMLTagDefs.EL_BEG(this.sigmlDocElementType);
        int i = sigmltxt.indexOf(docelbegin);
        if (0 <= i) {
            sigmltxt = sigmltxt.substring(i);
        }
        StringReader srdr = new StringReader(sigmltxt);
        InputSource sins = new InputSource(srdr);
        try {
            this.sigmlDoc = this.docBuilder.parse(sins);
        }
        catch (IOException iox) {
            this.fail("parse", iox);
        }
        catch (SAXException sx) {
            this.fail("parse", sx);
        }
    }

    protected void doConvertSiGML() {
        this.gesturalErrorCount = 0;
        this.gesturalErrorText = "";
        Element SIGML_DOC_EL = this.sigmlDoc.getDocumentElement();
        NodeList DOC_CHILDREN = SIGML_DOC_EL.getChildNodes();
        int N = DOC_CHILDREN.getLength();
        int sign_ix = 0;
        for (int i = 0; i != N; ++i) {
            Node NODE = DOC_CHILDREN.item(i);
            String NODE_TAG = NODE.getNodeName();
            short NODE_TYPE = NODE.getNodeType();
            if (NODE_TYPE == 1 && NODE_TAG.equals("hns_sign")) {
                Element HNS_S_EL = (Element)NODE;
                this.doConvertHNSSignElement(HNS_S_EL);
                if (this.gesturalSignError != null) {
                    String gloss = HNS_S_EL.getAttribute("gloss");
                    ++this.gesturalErrorCount;
                    this.gesturalErrorText = this.gesturalErrorText + String.format("########  index=%3d  gloss=\"%s\"  ########", sign_ix, gloss) + SiGMLTagDefs.EOL + this.gesturalSignError + SiGMLTagDefs.EOL;
                }
                SIGML_DOC_EL.replaceChild(this.gesturalSign, NODE);
            }
            if (NODE_TYPE != 1 || !NODE_TAG.equals("hns_sign") && !NODE_TAG.equals("hamgestural_sign")) continue;
            ++sign_ix;
        }
        this.makeElText(SIGML_DOC_EL);
        String sigmlhdr = HSDocParameters.getSiGMLXMLDecl(null);
        this.gesturalSiGMLDocText = sigmlhdr + this.elText;
        if (this.elTextError != null) {
            ++this.gesturalErrorCount;
            this.gesturalErrorText = this.gesturalErrorText + this.elTextError + SiGMLTagDefs.EOL;
        }
    }

    protected void doConvertHNSSignElement(Element hel) {
        this.gesturalSign = null;
        this.gesturalSignError = null;
        this.makeElText(hel);
        String hnssignel = this.elText;
        this.gesturalSignError = this.elTextError;
        HNSSign hnssign = this.hstohConverter.convert(hnssignel);
        try {
            Element hml = this.htohConverter.hmlSign(hnssign);
            this.logHMLIfNeeded(hml);
            Element gsigml = this.htosConverter.sigmlSignForHML(hml);
            this.gesturalSign = (Element)this.sigmlDoc.importNode(gsigml, true);
        }
        catch (HNSToHML.HNSToHMLException hhx) {
            this.gesturalSignError = "HNSToHML error: " + hhx.getMessage();
        }
        catch (HMLToSiGML.HMLToSiGMLException hsx) {
            this.gesturalSignError = "HMLToSiGML error: " + hsx.getMessage();
        }
        catch (DOMException dx) {
            this.gesturalSignError = "import error: " + dx.getMessage();
        }
        if (this.gesturalSign == null) {
            this.gesturalSign = this.emptyGesturalEl(hnssign.gloss());
        }
    }

    private void logHMLIfNeeded(Element hml) {
        if (this.DO_SHOW_HML) {
            String gloss = hml == null ? "unknown" : hml.getAttribute("gloss");
            System.err.println("########  HML -- gloss: " + gloss + "  ########");
            if (hml == null) {
                System.err.println("null");
            } else {
                String saveet = this.elText;
                this.makeElText(hml);
                String hmltxt = this.elText;
                this.elText = saveet;
                System.err.println(hmltxt);
            }
        }
    }

    protected Element emptyGesturalEl(String gloss) {
        Element gsel = null;
        try {
            gsel = this.sigmlDoc.createElement("hamgestural_sign");
            gsel.setAttribute("gloss", gloss);
        }
        catch (DOMException dx) {
            this.gesturalSignError = "g-sign create: " + dx.getMessage();
        }
        return gsel;
    }

    protected void makeElText(Element el) {
        this.makeElText(el, false);
    }

    protected void makeElText(Element el, boolean doxmldecl) {
        this.elText = null;
        this.elTextError = null;
        try {
            XmlElementTextGen etgen = new XmlElementTextGen(true, doxmldecl);
            this.elText = etgen.getText(el);
        }
        catch (TransformerException tx) {
            this.elTextError = "convert: " + tx.getMessage();
        }
    }

    protected void fail(String msg, Exception x) throws SiGMLConvertException {
        String fullmsg = "SiGMLDocHNSToGestural: " + msg + ": " + x.getMessage();
        throw new SiGMLConvertException(fullmsg);
    }

    public static class SiGMLConvertException
    extends Exception {
        public SiGMLConvertException(String msg) {
            super(msg);
        }
    }
}

