/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import hnscnvt.HMLToSiGML;
import hnscnvt.HNSSign;
import hnscnvt.HNSSignElementToHNS;
import hnscnvt.HNSToHML;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sigmlgen.GSiGMLSign;
import sigmlgen.SiGMLTagDefs;
import sigmlgen.SigningRefProcessor;
import sigmlgen.playerctrl.PlayerSettings;
import util.StringUtils;
import xml.XmlElementTextGen;

public class SiGMLChildNodesProcessor {
    protected static final String OPEN_SIGML = SiGMLTagDefs.EL_OPEN("sigml") + StringUtils.EOL;
    protected static final String CLOSE_SIGML = StringUtils.EOL + SiGMLTagDefs.EL_CLOSE("sigml");
    protected HNSSignElementToHNS hstohConverter;
    protected HNSToHML htohConverter;
    protected HMLToSiGML htosConverter;
    protected XmlElementTextGen xmlTextGen;
    protected final URI BASE_URI;
    protected final Document SIGML_DOC;
    protected final NodeList CHILDREN;
    protected Element psElement;
    protected GSiGMLSign[] srSigns;
    protected ArrayList<GSiGMLSign[]> signingRefSignLists;
    protected int countSigns;
    protected GSiGMLSign[] gSigns;

    public SiGMLChildNodesProcessor(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen, URI base, Document sigmldoc, NodeList childnodes) {
        this.setConverters(hstoh, htoh, htos, xtgen);
        this.BASE_URI = base;
        this.SIGML_DOC = sigmldoc;
        this.CHILDREN = childnodes;
        GSiGMLSign[] EMPTY_SIGNS = new GSiGMLSign[]{};
        this.gSigns = EMPTY_SIGNS;
        this.preScanChildNodes();
        this.buildSignsForChildNodes();
    }

    public GSiGMLSign[] getSigns() {
        return this.gSigns;
    }

    protected void setConverters(HNSSignElementToHNS hstoh, HNSToHML htoh, HMLToSiGML htos, XmlElementTextGen xtgen) {
        this.hstohConverter = hstoh;
        this.htohConverter = htoh;
        this.htosConverter = htos;
        this.xmlTextGen = xtgen;
    }

    protected void preScanChildNodes() {
        int N_CH = this.CHILDREN.getLength();
        this.signingRefSignLists = new ArrayList(Math.min(N_CH, 4));
        this.psElement = null;
        int isgn = 0;
        for (int i = 0; i != N_CH; ++i) {
            Node node = this.CHILDREN.item(i);
            if (node.getNodeType() != 1) continue;
            String tag = node.getNodeName();
            if (tag.equals("player_settings")) {
                this.psElement = (Element)node;
                continue;
            }
            if (tag.equals("hns_sign") || tag.equals("hamgestural_sign")) {
                ++isgn;
                this.psElement = null;
                continue;
            }
            if (!tag.equals("signing_ref")) continue;
            this.generateSignsForSigningRef((Element)node);
            isgn += this.srSigns.length;
        }
        this.countSigns = isgn;
    }

    protected void generateSignsForSigningRef(Element srefel) {
        SigningRefProcessor srprcssr = new SigningRefProcessor(this.hstohConverter, this.htohConverter, this.htosConverter, this.xmlTextGen, this.BASE_URI, srefel);
        this.srSigns = srprcssr.getSigns();
        this.signingRefSignLists.add(this.srSigns);
        if (this.psElement != null && this.srSigns.length != 0) {
            this.srSigns[0].supplementPlayerSettings(new PlayerSettings(this.psElement));
            this.psElement = null;
        }
    }

    protected void buildSignsForChildNodes() {
        int N = this.countSigns;
        this.gSigns = new GSiGMLSign[N];
        int isgn = 0;
        int isrl = 0;
        this.psElement = null;
        int N_CH = this.CHILDREN.getLength();
        for (int i = 0; i != N_CH; ++i) {
            Node node = this.CHILDREN.item(i);
            if (node.getNodeType() != 1) continue;
            String tag = node.getNodeName();
            if (tag.equals("player_settings")) {
                this.psElement = (Element)node;
                continue;
            }
            boolean ishns = false;
            boolean ishg = false;
            if (tag.equals("hns_sign")) {
                ishns = true;
            } else if (tag.equals("hamgestural_sign")) {
                ishg = true;
            }
            if (ishns || ishg) {
                this.gSigns[isgn] = this.getSignForElement((Element)node, ishns);
                ++isgn;
                this.psElement = null;
                continue;
            }
            if (!tag.equals("signing_ref")) continue;
            this.insertSigningRefSigns(isrl, isgn);
            ++isrl;
            isgn += this.srSigns.length;
        }
    }

    protected GSiGMLSign getSignForElement(Element sel, boolean ishns) {
        String gloss = sel.getAttribute("gloss");
        Element gel = ishns ? this.gesturalElementForHNS(sel) : sel;
        String geltxt = this.sigmlText(gel);
        PlayerSettings ps = null;
        if (this.psElement != null) {
            ps = new PlayerSettings(this.psElement);
        }
        return new GSiGMLSign(geltxt, gloss, ps);
    }

    protected Element gesturalElementForHNS(Element hel) {
        Element gsigml = null;
        String err = null;
        HNSSign hnssign = this.hstohConverter.convert(hel);
        try {
            Element hml = this.htohConverter.hmlSign(hnssign);
            gsigml = this.htosConverter.sigmlSignForHML(hml);
        }
        catch (HNSToHML.HNSToHMLException hhx) {
            err = "HNSToHML error: " + hhx.getMessage();
        }
        catch (HMLToSiGML.HMLToSiGMLException hsx) {
            err = "HMLToSiGML error: " + hsx.getMessage();
        }
        catch (DOMException dx) {
            err = "import error: " + dx.getMessage();
        }
        if (err != null) {
            System.out.println("<hns>-to-<hamgestural> sign conversion: " + err);
        }
        if (gsigml == null) {
            gsigml = this.emptyGesturalEl(hnssign.gloss());
        }
        return gsigml;
    }

    protected Element emptyGesturalEl(String gloss) {
        Element gsel = null;
        try {
            gsel = this.SIGML_DOC.createElement("hamgestural_sign");
            gsel.setAttribute("gloss", gloss);
        }
        catch (DOMException dx) {
            System.out.println("g-sign create: " + dx.getMessage());
        }
        return gsel;
    }

    protected String sigmlText(Element el) {
        String eltxt = null;
        try {
            eltxt = this.xmlTextGen.getText(el, OPEN_SIGML, CLOSE_SIGML);
        }
        catch (TransformerException tx) {
            System.out.println("convert: " + tx.getMessage());
        }
        return eltxt;
    }

    protected void insertSigningRefSigns(int irefs, int isigns) {
        this.srSigns = this.signingRefSignLists.get(irefs);
        if (this.psElement != null && this.srSigns.length != 0) {
            this.psElement = null;
        }
        int i = isigns;
        GSiGMLSign[] arr$ = this.srSigns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            GSiGMLSign gs;
            this.gSigns[i] = gs = arr$[i$];
            ++i;
        }
    }
}

