/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import java.io.IOException;
import java.io.OutputStream;
import util.StringUtils;

public class HSDocParameters {
    public static final String SIGML_BASE_URI_STD = "http://www.visicast.cmp.uea.ac.uk/sigml/";
    public static final String SIGML_BASE_URI_ALT = "http://www.visicast.org/sigml/";
    private static final String XML_ENCODING_STD = "UTF-8";
    private static final String HML_TAG_STD = "hamnosysml";
    private static final String SIGML_TAG_STD = "sigml";
    private static final String HML_DTD_STD = "http://www.visicast.cmp.uea.ac.uk/sigml/hamnosysml.dtd";
    private static final String SIGML_DTD_STD = "http://www.visicast.cmp.uea.ac.uk/sigml/sigml.dtd";
    private static final String H2S_DOC_STD_URI = "sigmlgen/xslth4/h2sDocumentH4.xsl";
    private static final String H2S_SIGN_STD_URI = "sigmlgen/xslth4/h2sSingleSignH4.xsl";
    public static final String STD_HML_PREFIX = HSDocParameters.getHMLPrefix(null, null, null);
    public static final String STD_HML_SUFFIX = HSDocParameters.getHMLSuffix(null);
    public static final String STD_SIGML_PREFIX = HSDocParameters.getSiGMLPrefix(null, null, null);
    public static final String STD_SIGML_SUFFIX = HSDocParameters.getSiGMLSuffix(null);

    public static final String getEncoding(String enc) {
        return enc != null ? enc : XML_ENCODING_STD;
    }

    public static final String getHMLTag(String htag) {
        return htag != null ? htag : HML_TAG_STD;
    }

    public static final String getSiGMLTag(String stag) {
        return stag != null ? stag : SIGML_TAG_STD;
    }

    public static final String getHMLDTD(String hdtd) {
        return hdtd != null ? hdtd : HML_DTD_STD;
    }

    public static final String getSiGMLDTD(String sdtd) {
        return sdtd != null ? sdtd : SIGML_DTD_STD;
    }

    public static final String getH2SDocURI(String h2sd) {
        return h2sd != null ? h2sd : H2S_DOC_STD_URI;
    }

    public static final String getH2SSignsURI(String h2ss) {
        return h2ss != null ? h2ss : H2S_SIGN_STD_URI;
    }

    public static void writeHMLPrefix(OutputStream hmls, String henc, String hdtd, String htag) throws IOException {
        String[] hpfxlines = HSDocParameters.getHMLPrefixLines(henc, hdtd, htag);
        HSDocParameters.writeLines(hmls, henc, hpfxlines);
    }

    public static void writeHMLSuffix(OutputStream hmls, String henc, String htag) throws IOException {
        String enc = HSDocParameters.getEncoding(henc);
        String[] hsfxline = HSDocParameters.getHMLSuffixLine(htag);
        HSDocParameters.writeLines(hmls, enc, hsfxline);
    }

    public static String wrapHMLDocBodyEls(String bodyels) {
        int pfxlen = STD_HML_PREFIX.length();
        int bodylen = bodyels.length();
        int sfxlen = STD_HML_SUFFIX.length();
        StringBuilder sbuf = new StringBuilder(pfxlen + bodylen + sfxlen);
        sbuf.append(STD_HML_PREFIX);
        sbuf.append(bodyels);
        sbuf.append(STD_HML_SUFFIX);
        String result = sbuf.toString();
        sbuf.setLength(0);
        sbuf = null;
        return result;
    }

    public static String getHMLHeader(String htag) {
        return HSDocParameters.getHMLHeader(null, null, htag);
    }

    public static String getHMLHeader(String henc, String hdtd, String htag) {
        String[] hhlines = HSDocParameters.getHMLPrefixLines(henc, hdtd, htag);
        String hh = hhlines[0] + StringUtils.EOL + hhlines[1] + StringUtils.EOL;
        return hh;
    }

    public static String getHMLPrefix(String henc, String hdtd, String htag) {
        String[] hpfxlines = HSDocParameters.getHMLPrefixLines(henc, hdtd, htag);
        return StringUtils.linesToOneString(hpfxlines);
    }

    public static String getHMLSuffix(String htag) {
        String[] hsfxline = HSDocParameters.getHMLSuffixLine(htag);
        return StringUtils.linesToOneString(hsfxline);
    }

    public static String[] getHMLPrefixLines(String henc, String hdtd, String htag) {
        String enc = HSDocParameters.getEncoding(henc);
        String dtd = HSDocParameters.getHMLDTD(hdtd);
        String tag = HSDocParameters.getHMLTag(htag);
        String[] hpfxlines = new String[]{"<?xml version=\"1.0\" encoding=\"" + enc + "\"?>", "<!DOCTYPE " + tag + " SYSTEM \"" + dtd + "\">", "<" + tag + ">", ""};
        return hpfxlines;
    }

    public static String[] getHMLSuffixLine(String htag) {
        String tag = HSDocParameters.getHMLTag(htag);
        String[] hsfxlines = new String[]{"</" + tag + ">"};
        return hsfxlines;
    }

    public static void writeSiGMLPrefix(OutputStream sigmls, String senc, String sdtd, String stag) throws IOException {
        String[] spfxlines = HSDocParameters.getSiGMLPrefixLines(senc, sdtd, stag);
        HSDocParameters.writeLines(sigmls, senc, spfxlines);
    }

    public static void writeSiGMLSuffix(OutputStream sigmls, String senc, String stag) throws IOException {
        String enc = HSDocParameters.getEncoding(senc);
        String[] ssfxline = HSDocParameters.getSiGMLSuffixLine(stag);
        HSDocParameters.writeLines(sigmls, enc, ssfxline);
    }

    public static String wrapSiGMLDocBodyEls(String bodyels) {
        int pfxlen = STD_SIGML_PREFIX.length();
        int bodylen = bodyels.length();
        int sfxlen = STD_SIGML_SUFFIX.length();
        StringBuilder sbuf = new StringBuilder(pfxlen + bodylen + sfxlen);
        sbuf.append(STD_SIGML_PREFIX);
        sbuf.append(bodyels);
        sbuf.append(STD_SIGML_SUFFIX);
        String result = sbuf.toString();
        sbuf.setLength(0);
        sbuf = null;
        return result;
    }

    public static String getSiGMLXMLDecl(String senc) {
        String[] shlines = HSDocParameters.getSiGMLPrefixLines(senc, null, null);
        return shlines[0] + StringUtils.EOL;
    }

    public static String getSiGMLHeader(String stag) {
        return HSDocParameters.getSiGMLHeader(null, null, stag);
    }

    public static String getSiGMLHeader(String senc, String sdtd, String stag) {
        String[] shlines = HSDocParameters.getSiGMLPrefixLines(senc, sdtd, stag);
        String sh = shlines[0] + StringUtils.EOL + shlines[1] + StringUtils.EOL;
        return sh;
    }

    public static String getSiGMLPrefix(String senc, String sdtd, String stag) {
        String[] spfxlines = HSDocParameters.getSiGMLPrefixLines(senc, sdtd, stag);
        return StringUtils.linesToOneString(spfxlines);
    }

    public static String getSiGMLPrefix(String stag) {
        return HSDocParameters.getSiGMLPrefix(null, null, stag);
    }

    public static String getSiGMLSuffix(String stag) {
        String[] ssfxline = HSDocParameters.getSiGMLSuffixLine(stag);
        return StringUtils.linesToOneString(ssfxline);
    }

    public static String[] getSiGMLPrefixLines(String senc, String sdtd, String stag) {
        String enc = HSDocParameters.getEncoding(senc);
        String dtd = HSDocParameters.getSiGMLDTD(sdtd);
        String tag = HSDocParameters.getSiGMLTag(stag);
        String[] spfxlines = new String[]{"<?xml version=\"1.0\" encoding=\"" + enc + "\"?>", "<!DOCTYPE " + tag + " SYSTEM \"" + dtd + "\">", "<" + tag + ">", ""};
        return spfxlines;
    }

    public static String[] getSiGMLSuffixLine(String stag) {
        String tag = HSDocParameters.getSiGMLTag(stag);
        String[] ssfxlines = new String[]{"</" + tag + ">"};
        return ssfxlines;
    }

    protected static void writeLines(OutputStream os, String enc, String[] lns) throws IOException {
        int n = lns.length;
        for (int i = 0; i != n; ++i) {
            os.write((lns[i] + StringUtils.EOL).getBytes(enc));
        }
    }
}

