/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import util.StringUtils;

public class HNSSiGMLNonManuals {
    public static final char MOUTH_PICTURE_LETTER = 'm';
    public static final char EYES_LETTER = 'e';
    public static final String MOUTH_GESTURE_LETTERS = "djlct";
    public static final String NON_MOUTH_RELATED_LETTERS = "sbhen";
    public static final String[] EYES_TAG_LISTS = new String[]{"AD FR HD HI HC UP DN LE RI NO RO LU LD RU RD", "RB RR RL FU", "WB WR WL SB SR SL CB CR CL TB TR TL BB"};
    public static final String[] EYE_RELATED_HML_TAGS = new String[]{"hnm_eyegaze", "hnm_eyebrows", "hnm_eyelids"};
    public static final String[] NON_MOUTH_RELATED_HNM_TAGS = new String[]{"hnm_shoulder", "hnm_body", "hnm_head", null, "hnm_nose"};
    public static final String[] NON_MOUTH_TAG_LISTS = new String[]{"UL UR UB HL HR HB SL SR SB", "RL RR TL TR TF TB SI HE ST RD", "NO SH SR SL TR TL NF NB PF PB LI ND NU", EYES_TAG_LISTS[0] + " " + EYES_TAG_LISTS[1] + " " + EYES_TAG_LISTS[2], "WR TW WI"};
    public static final int[] MOUTH_GESTURE_TAG_LIMITS = new int[]{9, 4, 35, 13, 17};

    private HNSSiGMLNonManuals() {
    }

    public static final String checkAndNormalizeNMTag(String nmtag) {
        char ch0 = Character.toLowerCase(nmtag.charAt(0));
        String newtag = null;
        if (ch0 == 'm') {
            newtag = 'm' + nmtag.substring(1);
        } else if (nmtag.length() == 3) {
            String ID = nmtag.substring(1).toUpperCase();
            int mgi = MOUTH_GESTURE_LETTERS.indexOf(ch0);
            if (0 <= mgi) {
                int mgval = StringUtils.nnVal(ID, null);
                if (0 < mgval && mgval <= MOUTH_GESTURE_TAG_LIMITS[mgi]) {
                    newtag = Character.toUpperCase(ch0) + ID;
                }
            } else {
                int nmi = NON_MOUTH_RELATED_LETTERS.indexOf(ch0);
                if (0 <= nmi) {
                    if (0 <= NON_MOUTH_TAG_LISTS[nmi].indexOf(ID)) {
                        newtag = ch0 + ID;
                    }
                } else {
                    int xval = StringUtils.nnVal(ID, null);
                    if (0 <= xval) {
                        newtag = Character.toUpperCase(ch0) + ID;
                    }
                }
            }
        }
        return newtag;
    }

    public static final String hnsNMElementTag(String hnstnm) {
        String hnseltag = null;
        char t = Character.toLowerCase(hnstnm.charAt(0));
        if (t == 'm') {
            hnseltag = "hnm_mouthpicture";
        } else {
            int mgi = MOUTH_GESTURE_LETTERS.indexOf(t);
            if (0 <= mgi) {
                hnseltag = "hnm_mouthgesture";
            } else {
                int nmi = NON_MOUTH_RELATED_LETTERS.indexOf(t);
                if (0 <= nmi) {
                    hnseltag = NON_MOUTH_RELATED_HNM_TAGS[nmi];
                    if (hnseltag == null) {
                        String ID = hnstnm.substring(1).toUpperCase();
                        int ei = 0;
                        while (EYES_TAG_LISTS[ei].indexOf(ID) < 0) {
                            ++ei;
                        }
                        hnseltag = EYE_RELATED_HML_TAGS[ei];
                    }
                } else {
                    hnseltag = "hnm_extra";
                }
            }
        }
        return hnseltag;
    }

    public static final String hnsNMAttrName(String hnstnm) {
        char ch0 = Character.toLowerCase(hnstnm.charAt(0));
        return ch0 == 'm' ? "picture" : "tag";
    }

    public static final String hnsNMAttrValue(String hnstnm) {
        String htailU2;
        char ch0 = Character.toLowerCase(hnstnm.charAt(0));
        char ch0U = Character.toUpperCase(ch0);
        String htail = hnstnm.substring(1);
        String string = htailU2 = ch0 == 'm' ? null : htail.toUpperCase().substring(0, 2);
        return ch0 == 'm' ? HNSSiGMLNonManuals.xmlAttrValueString(htail) : (0 <= MOUTH_GESTURE_LETTERS.indexOf(ch0) ? "" + ch0U + htailU2 : (0 <= NON_MOUTH_RELATED_LETTERS.indexOf(ch0) ? htailU2 : "" + ch0U + htailU2));
    }

    public static final String xmlAttrValueString(String aval) {
        String xmlSpecials = "<>&'\"";
        String[] escapes = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
        int N = aval.length();
        StringBuilder abuf = new StringBuilder(30 + N);
        for (int i = 0; i != N; ++i) {
            char ch = aval.charAt(i);
            int xs = xmlSpecials.indexOf(ch);
            abuf.append(xs < 0 ? "" + ch : escapes[xs]);
        }
        return abuf.toString();
    }

    public static final String hnsNMTokenForNMElement(String nmeltag, Attributes nmattrs) {
        return nmeltag.equals("hnm_mouthpicture") ? 'm' + nmattrs.getValue("picture") : HNSSiGMLNonManuals.hnsNMTokenForNonPic(nmeltag, nmattrs.getValue("tag"));
    }

    public static final String hnsNMTokenForNMElement(Element nmtagel) {
        String NM_TAG = nmtagel.getTagName().intern();
        return NM_TAG.equals("hnm_mouthpicture") ? 'm' + nmtagel.getAttribute("picture") : HNSSiGMLNonManuals.hnsNMTokenForNonPic(NM_TAG, nmtagel.getAttribute("tag"));
    }

    private static final String hnsNMTokenForNonPic(String NM_TAG, String TAG_VAL) {
        String tok = null;
        if (NM_TAG.equals("hnm_mouthgesture")) {
            tok = TAG_VAL;
        } else {
            int i = 0;
            int ii = EYE_RELATED_HML_TAGS.length;
            while (i != ii) {
                if (NM_TAG.equals(EYE_RELATED_HML_TAGS[i])) {
                    ii = i;
                    continue;
                }
                ++i;
            }
            if (i != EYE_RELATED_HML_TAGS.length) {
                tok = 'e' + TAG_VAL;
            } else {
                i = 0;
                ii = NON_MOUTH_RELATED_HNM_TAGS.length;
                while (i != ii) {
                    if (NM_TAG.equals(NON_MOUTH_RELATED_HNM_TAGS[i])) {
                        ii = i;
                        continue;
                    }
                    ++i;
                }
                tok = i != NON_MOUTH_RELATED_HNM_TAGS.length ? NON_MOUTH_RELATED_LETTERS.charAt(i) + TAG_VAL : TAG_VAL;
            }
        }
        return tok;
    }
}

