/*
 * Decompiled with CFR 0.152.
 */
package sigmlgen;

import sigmlgen.playerctrl.AmbientMotionFlags;
import sigmlgen.playerctrl.CameraSettings;
import sigmlgen.playerctrl.PlayerSettings;

public class GSiGMLSign {
    protected String signText;
    protected String gloss;
    protected CameraSettings cameraSettings;
    protected AmbientMotionFlags amFlags;

    public GSiGMLSign(String gsigml, String glss, PlayerSettings psttngs) {
        this.signText = gsigml;
        this.gloss = glss;
        this.cameraSettings = null;
        this.amFlags = null;
        this.setPlayerSettings(psttngs);
    }

    public GSiGMLSign(String gsigml, String glss, CameraSettings cam, AmbientMotionFlags amf) {
        this.signText = gsigml;
        this.gloss = glss;
        this.cameraSettings = cam;
        this.amFlags = amf;
    }

    public GSiGMLSign(GSiGMLSign sign) {
        this(sign.getSiGMLForSign(), sign.getGloss(), sign.getCameraSettings(), sign.getAmbientMotionFlags());
    }

    public void setPlayerSettings(PlayerSettings ps) {
        if (ps != null) {
            this.cameraSettings = ps.getCameraSettings();
            this.amFlags = ps.getAmbients();
        }
    }

    public void supplementPlayerSettings(PlayerSettings ps) {
        if (ps != null) {
            if (this.cameraSettings == null) {
                this.cameraSettings = ps.getCameraSettings();
            }
            if (this.amFlags == null) {
                this.amFlags = ps.getAmbients();
            }
        }
    }

    public String getSiGMLForSign() {
        return this.signText;
    }

    public String getGloss() {
        return this.gloss;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public AmbientMotionFlags getAmbientMotionFlags() {
        return this.amFlags;
    }

    public boolean hasPlayerSettings() {
        return this.cameraSettings != null || this.amFlags != null;
    }
}

