/*
 * Decompiled with CFR 0.152.
 */
package hnsgen;

import hnscnvt.HNSSign;

public class HNS3To4 {
    private static char HNS_SYMM_PAR = (char)48;
    private static char HNS_SYMM_LR = (char)49;
    private static String HNS_SYMM = "[" + HNS_SYMM_PAR + HNS_SYMM_LR + "]";
    private static char HNS_FIST = (char)50;
    private static char HNS_FLAT_HAND = (char)51;
    private static char HNS_HAND_2 = (char)52;
    private static char HNS_HAND_23 = (char)53;
    private static char HNS_HAND_23_S = (char)54;
    private static char HNS_HAND_2345 = (char)55;
    private static char HNS_PINCH_12 = (char)58;
    private static char HNS_PINCH_ALL = (char)59;
    private static char HNS_PINCH_12_OPEN = (char)60;
    private static char HNS_CEE_12 = (char)61;
    private static char HNS_CEE_ALL = (char)62;
    private static char HNS_CEE_12_OPEN = (char)63;
    private static char HNS_TH_OUT = (char)56;
    private static char HNS_TH_ACROSS = (char)57;
    private static char HNS_TH_OPEN = (char)64;
    private static String HNS_TH_MOD = "[" + HNS_TH_OUT + HNS_TH_ACROSS + HNS_TH_OPEN + "]";
    private static char HNS_FI_STRGHT = (char)65;
    private static char HNS_FI_BEND = (char)66;
    private static char HNS_FI_HOOK = (char)67;
    private static char HNS_DBL_BEND = (char)69;
    private static char HNS_DBL_HOOK = (char)70;
    private static String HNS_BEND_MOD = "[" + HNS_FI_STRGHT + HNS_FI_BEND + HNS_FI_HOOK + HNS_DBL_BEND + HNS_DBL_HOOK + "]";
    private static char HNS_EFD_U = (char)72;
    private static char HNS_EFD_UR = (char)73;
    private static char HNS_EFD_R = (char)74;
    private static char HNS_EFD_DR = (char)75;
    private static char HNS_EFD_D = (char)76;
    private static char HNS_EFD_DL = (char)77;
    private static char HNS_EFD_L = (char)78;
    private static char HNS_EFD_UL = (char)79;
    private static char HNS_EFD_OL = (char)80;
    private static char HNS_EFD_O = (char)81;
    private static char HNS_EFD_OR = (char)82;
    private static char HNS_EFD_IL = (char)83;
    private static char HNS_EFD_I = (char)84;
    private static char HNS_EFD_IR = (char)85;
    private static char HNS_EFD_UI = (char)86;
    private static char HNS_EFD_DI = (char)87;
    private static char HNS_EFD_DO = (char)88;
    private static char HNS_EFD_UO = (char)89;
    private static String HNS_EFD_2DIR = "[" + HNS_EFD_UR + HNS_EFD_DR + HNS_EFD_DL + HNS_EFD_UL + HNS_EFD_OL + HNS_EFD_OR + HNS_EFD_IL + HNS_EFD_IR + HNS_EFD_UI + HNS_EFD_DI + HNS_EFD_DO + HNS_EFD_UO + "]";
    private static String HNS_EFD_2DIR_PAIR = HNS_EFD_2DIR + HNS_EFD_2DIR;
    private static char HNS_BEHIND = (char)106;
    private static char HNS_ELBOW = (char)132;
    private static char HNS_ELBOW_INSIDE = (char)133;
    private static char HNS_WRIST_BACK = (char)135;
    private static char HNS_WRIST_PULSE = (char)136;
    private static char HNS_PALM = (char)138;
    private static char HNS_HAND_BACK = (char)139;
    private static char HNS_THUMB = (char)140;
    private static char HNS_FI_2 = (char)141;
    private static char HNS_FI_3 = (char)142;
    private static char HNS_FI_4 = (char)143;
    private static char HNS_FI_5 = (char)144;
    private static char HNS_FI_TIP = (char)148;
    private static char HNS_FI_NAIL = (char)149;
    private static char HNS_FI_PAD = (char)150;
    private static char HNS_FI_MID = (char)151;
    private static char HNS_FI_BASE = (char)152;
    private static char HNS_FI_SIDE = (char)153;
    private static char HNS_MOVE_CROSS = (char)179;
    private static char HNS_MOVE_X = (char)180;
    private static char HNS_SMALL_MOD = (char)181;
    private static char HNS_LARGE_MOD = (char)182;
    private static char HNS_PAR_BEGIN = (char)190;
    private static char HNS_PAR_END = (char)191;
    private static char HNS_SEQ_BEGIN = (char)213;
    private static char HNS_SEQ_END = (char)214;
    private static char HNS_RPT_START_1 = (char)209;
    private static char HNS_RPT_START_SEV = (char)210;
    private static char HNS_RPT_CONT_1 = (char)211;
    private static char HNS_RPT_CONT_SEV = (char)212;
    private static char HNS_RPT_REVERSE = (char)216;
    private static String HNS_DIGITS = "[" + HNS_THUMB + HNS_FI_2 + HNS_FI_3 + HNS_FI_4 + HNS_FI_5 + "]+";
    private static String HNS_FI_PARTS = "[" + HNS_FI_TIP + HNS_FI_NAIL + HNS_FI_PAD + HNS_FI_MID + HNS_FI_BASE + HNS_FI_SIDE + "]+";
    private static String HNS_EFD_REV = "[" + HNS_EFD_OL + HNS_EFD_OR + HNS_EFD_IL + HNS_EFD_IR + "]";

    public HNSSign convert(HNSSign hns) {
        String man = hns.man();
        man = HNS3To4.swap(man, HNS_FI_PARTS, HNS_DIGITS);
        man = HNS3To4.swap(man, HNS_TH_MOD, HNS_BEND_MOD);
        man = HNS3To4.swapAt(man, HNS_SYMM, "" + HNS_FI_STRGHT, "" + HNS_LARGE_MOD);
        man = HNS3To4.change(man, "" + HNS_WRIST_PULSE, "" + HNS_WRIST_BACK + HNS_PALM);
        man = HNS3To4.change(man, "" + HNS_FI_PAD, "" + HNS_FI_NAIL + HNS_PALM);
        man = HNS3To4.change(man, "" + HNS_ELBOW, "" + HNS_ELBOW_INSIDE + HNS_BEHIND);
        man = HNS3To4.change(man, "" + HNS_PINCH_ALL + HNS_FI_2, "" + HNS_PINCH_ALL);
        man = HNS3To4.fixEFDPairs(man);
        return new HNSSign(man, hns.nonMan(), hns.gloss(), null);
    }

    public static final char MOVE_CROSS() {
        return HNS_MOVE_CROSS;
    }

    public static final char MOVE_X() {
        return HNS_MOVE_X;
    }

    public static final char PAR_BEGIN() {
        return HNS_PAR_BEGIN;
    }

    public static final char SEQ_BEGIN() {
        return HNS_SEQ_BEGIN;
    }

    public static final char PAR_END() {
        return HNS_PAR_END;
    }

    public static final char SEQ_END() {
        return HNS_SEQ_END;
    }

    public static final char PS_END(char ps) {
        return ps == HNS_PAR_BEGIN ? HNS_PAR_END : (ps == HNS_SEQ_BEGIN ? HNS_SEQ_END : ps);
    }

    public static final boolean IS_RPT(char ch) {
        return ch == HNS_RPT_START_1 || ch == HNS_RPT_START_SEV || ch == HNS_RPT_CONT_1 || ch == HNS_RPT_CONT_SEV || ch == HNS_RPT_REVERSE;
    }

    private static String fixEFDPairs(String s) {
        String sf = s;
        int n = s.split(HNS_EFD_2DIR_PAIR).length;
        if (1 < n) {
            sf = HNS3To4.swap(sf, "" + HNS_EFD_OL, "" + HNS_EFD_UO);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_OL, "" + HNS_EFD_DO);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_IL, "" + HNS_EFD_UI);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_IL, "" + HNS_EFD_DI);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_OR, "" + HNS_EFD_UO);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_OR, "" + HNS_EFD_DO);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_IR, "" + HNS_EFD_UI);
            sf = HNS3To4.swap(sf, "" + HNS_EFD_IR, "" + HNS_EFD_DI);
        }
        return sf;
    }

    private static String swap(String s, String p0, String p1) {
        return s.replaceAll("(" + p0 + ")(" + p1 + ")", "$2$1");
    }

    private static String swapAt(String s, String pre, String p0, String p1) {
        return s.replaceAll("(" + pre + ")(" + p0 + ")(" + p1 + ")", "$1$3$2");
    }

    private static String change(String s, String p0, String r) {
        return s.replaceAll(p0, r);
    }
}

