/*
 * Decompiled with CFR 0.152.
 */
package hnsgen;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLResolver;
import util.ResourceUtils;
import xml.CleanerEntityResolver;
import xml.InvalidXMLException;
import xml.XmlElementTextGen;
import xml.XmlValidator;

public class GToHNSSignSiGML {
    protected static final String G_TO_H_URI_STANDARD = "hnsgen/gToHNSSignSiGML.xsl";
    protected Transformer g2hXformer;
    protected XmlElementTextGen textGenerator;

    public GToHNSSignSiGML() throws GToHNSException {
        this(G_TO_H_URI_STANDARD);
    }

    public GToHNSSignSiGML(String g2huri) throws GToHNSException {
        String fullg2huri = ResourceUtils.getLocalURI(g2huri);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StreamSource g2hsrc = new StreamSource(fullg2huri);
        try {
            Templates templates = tfactory.newTemplates(g2hsrc);
            this.g2hXformer = templates.newTransformer();
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("Bad g-to-h xform uri (" + fullg2huri + ")", tcx);
        }
        try {
            this.textGenerator = new XmlElementTextGen(true);
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("XmlElementTextGen creation fails", tcx);
        }
    }

    public String sigmlSignAsDoc(String sigmlsign) {
        return HSDocParameters.wrapSiGMLDocBodyEls(sigmlsign);
    }

    public String hnsSignElementText(Element sigmlsel) throws GToHNSException {
        String sigmltxt = null;
        try {
            sigmltxt = this.textGenerator.getText(sigmlsel);
        }
        catch (TransformerException tx) {
            this.fail("SiGML text generation failure", tx);
        }
        return sigmltxt;
    }

    public String hnsSignTextForGSiGML(String gsstr) throws GToHNSException {
        StringReader gsrdr = new StringReader(gsstr);
        StreamSource gssrc = new StreamSource(gsrdr);
        DOMResult hnssrslt = new DOMResult();
        this.generateHNSSign(gssrc, (Result)hnssrslt);
        Document hnssdoc = (Document)hnssrslt.getNode();
        Element hnssel = hnssdoc.getDocumentElement();
        return this.hnsSignElementText(hnssel);
    }

    public String hnsSignTextForGSiGML(Element gsel) throws GToHNSException {
        Element hnssel = this.hnsSignForGSiGML(gsel);
        return this.hnsSignElementText(gsel);
    }

    public Element hnsSignForGSiGML(Element gsel) throws GToHNSException {
        DOMResult hnssrslt = new DOMResult();
        this.generateHNSSign(gsel, (Result)hnssrslt);
        Document hnssdoc = (Document)hnssrslt.getNode();
        Element hnssel = hnssdoc.getDocumentElement();
        return hnssel;
    }

    public void validateSiGML(String sdoctxt) throws GToHNSException {
        try {
            XmlValidator xv = new XmlValidator();
            StringReader srdr = new StringReader(sdoctxt);
            InputSource ins = new InputSource(srdr);
            xv.validate(ins, (CleanerEntityResolver)new SiGMLResolver());
        }
        catch (ParserConfigurationException pcx) {
            this.fail("parser config. error", pcx);
        }
        catch (InvalidXMLException ixx) {
            this.fail("SiGML invalid", ixx);
        }
        catch (SAXException sx) {
            this.fail("SAX error", sx);
        }
        catch (IOException iox) {
            this.fail("IO Error", iox);
        }
    }

    protected void generateHNSSign(Element gsel, Result hnssrslt) throws GToHNSException {
        DOMSource gssrc = new DOMSource(gsel);
        this.generateHNSSign(gssrc, hnssrslt);
    }

    protected void generateHNSSign(Source gssrc, Result hnssrslt) throws GToHNSException {
        try {
            this.g2hXformer.transform(gssrc, hnssrslt);
        }
        catch (TransformerException tx) {
            tx.printStackTrace();
            String msg = "G-SiGML-to-HNS-Sign transform error";
            this.fail(msg, tx);
        }
    }

    protected void fail(String msg, Exception x) throws GToHNSException {
        String fullmsg = msg + ": " + x.getMessage();
        throw new GToHNSException(fullmsg);
    }

    public static class GToHNSException
    extends Exception {
        public GToHNSException(String msg) {
            super(msg);
        }
    }
}

