/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import antlr.ANTLRException;
import antlr.TokenStream;
import antlr.collections.AST;
import hamnewlex.HamSignStringLexer;
import hamparse.Ham4Parser;
import hamwalk.HMLBuilder;
import hamwalk.Ham4HMLGen;
import hnscnvt.HNSNonManualConverter;
import hnscnvt.HNSSign;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLResolver;
import sigmlgen.SiGMLTagDefs;
import xml.CleanerEntityResolver;
import xml.InvalidXMLException;
import xml.XmlElementTextGen;
import xml.XmlValidator;

public class HNSToHML {
    protected HMLBuilder builder;

    public HNSToHML() throws HNSToHMLException {
        String bldrfailstr = "HMLBuilder creation failed";
        try {
            this.builder = new HMLBuilder();
        }
        catch (IOException iox) {
            this.fail(bldrfailstr, iox);
        }
        catch (DOMException dx) {
            this.fail(bldrfailstr, dx);
        }
        catch (ParserConfigurationException pcx) {
            this.fail(bldrfailstr, pcx);
        }
    }

    public String hmlSignAsDoc(String hmlsign) {
        return HSDocParameters.wrapHMLDocBodyEls(hmlsign);
    }

    public String rawHMLSignText(Element hmlel) throws HNSToHMLException {
        LSSerializer srlzr = this.builder.getLSSerializer();
        DOMConfiguration dcfg = srlzr.getDomConfig();
        dcfg.setParameter("xml-declaration", Boolean.FALSE);
        return srlzr.writeToString(hmlel);
    }

    public String hmlSignText(Element hmlel) throws HNSToHMLException {
        String rawhmltxt = this.rawHMLSignText(hmlel);
        return XmlElementTextGen.linesForPureXML(rawhmltxt);
    }

    public String hmlSignText(HNSSign hsign) throws HNSToHMLException {
        Element hmlel = this.hmlSign(hsign);
        return this.hmlSignText(hmlel);
    }

    public Element hmlSign(HNSSign hsign) throws HNSToHMLException {
        String gloss;
        Element hmlel = null;
        HamSignStringLexer hamlxr = new HamSignStringLexer(hsign.man(), Ham4Parser._tokenNames);
        try {
            AST htree = this.hnsManTree(hamlxr);
            hmlel = this.hmlElementFromHNSTree(htree);
            this.insertNonManualInSign(hmlel, hsign);
        }
        catch (ANTLRException ax) {
            this.fail("HNS-to-HML failure", ax);
        }
        this.copySignAttribute(hmlel, "gloss", hsign.gloss());
        if (hsign.hasTiming()) {
            this.copySignAttribute(hmlel, "duration", hsign.duration());
            this.copySignAttribute(hmlel, "speed", hsign.speed());
            this.copySignAttribute(hmlel, "timescale", hsign.timeScale());
        }
        if ((gloss = hsign.gloss()) != null && !gloss.equals("")) {
            hmlel.setAttribute("gloss", gloss);
        }
        return hmlel;
    }

    public void validateHML(String hdoctxt, boolean emptywsok) throws HNSToHMLException {
        try {
            String hdoc = emptywsok ? hdoctxt.replaceAll(">[\\s]+<", "><") : hdoctxt;
            XmlValidator xv = new XmlValidator();
            StringReader hrdr = new StringReader(hdoc);
            InputSource ins = new InputSource(hrdr);
            xv.validate(ins, (CleanerEntityResolver)new SiGMLResolver());
        }
        catch (ParserConfigurationException pcx) {
            this.fail("parser config. error", pcx);
        }
        catch (InvalidXMLException ixx) {
            this.fail("HML invalid", ixx);
        }
        catch (SAXException sx) {
            this.fail("SAX error", sx);
        }
        catch (IOException iox) {
            this.fail("IO Error", iox);
        }
    }

    public void validateHML(String hdoctxt) throws HNSToHMLException {
        this.validateHML(hdoctxt, false);
    }

    protected AST hnsManTree(TokenStream hamlxr) throws ANTLRException {
        Ham4Parser ham4prser = new Ham4Parser(hamlxr);
        ham4prser.hamsinglesign();
        ham4prser.checkForParseError();
        return ham4prser.getAST();
    }

    protected Element hmlElementFromHNSTree(AST htree) throws ANTLRException {
        Ham4HMLGen ham4wlkr = new Ham4HMLGen();
        return ham4wlkr.hamsignseq(htree, this.builder);
    }

    private void insertNonManualInSign(Element signel, HNSSign sign) {
        String nonman = null;
        if (sign.elementTextIsAvailable()) {
            String hnsel = sign.elementText();
            nonman = this.getNonManualElementText(hnsel);
        } else {
            HNSNonManualConverter cnvt = new HNSNonManualConverter();
            nonman = cnvt.nonManElement(sign.nonMan());
        }
        if (nonman != null) {
            Element nmel = this.builder.parseElement(nonman);
            this.builder.insertNonManual(signel, nmel);
        }
    }

    private String getNonManualElementText(String hnssignel) {
        String nonman = null;
        int i = hnssignel.indexOf(SiGMLTagDefs.EL_BEG("hamnosys_nonmanual"));
        if (0 <= i) {
            int j = hnssignel.indexOf(SiGMLTagDefs.EL_END("hamnosys_nonmanual"));
            j = hnssignel.indexOf(">", i <= j ? j : i) + 1;
            nonman = hnssignel.substring(i, j);
        }
        return nonman;
    }

    protected void copySignAttribute(Element hmlel, String attr, String aval) {
        if (aval != null && !aval.equals("")) {
            hmlel.setAttribute(attr, aval);
        }
    }

    protected void fail(String msg, Exception x) throws HNSToHMLException {
        String fullmsg = msg + ": " + x.getMessage();
        throw new HNSToHMLException(fullmsg);
    }

    public static class HNSToHMLException
    extends Exception {
        public HNSToHMLException(String msg) {
            super(msg);
        }
    }
}

