/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import hnscnvt.HNSSign;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import sigmlgen.HNSSiGMLNonManuals;
import sigmlgen.SiGMLResolver;
import util.HamNameMap;
import xml.BasicSAXHandler;
import xml.CleanerEntityResolver;

public class HNSSignSAXHandler
extends BasicSAXHandler {
    protected static final String HNS_SIGN = "hns_sign".intern();
    protected static final String HNS_MAN = "hamnosys_manual".intern();
    protected static final String HNS_NONMAN = "hamnosys_nonmanual".intern();
    protected static final String GLOSS = "gloss".intern();
    protected static final String DURATION = "duration".intern();
    protected static final String SPEED = "speed".intern();
    protected static final String TIMESCALE = "timescale".intern();
    protected HamNameMap hamNames;
    protected StringBuilder hnsBuf;
    protected boolean hnsManActive;
    protected boolean hnsNonManActive;
    protected String gloss;
    protected String duration;
    protected String speed;
    protected String timescale;
    protected String manHNS;
    protected String nonManHNS;
    protected HNSSign hnsSign;

    public HNSSignSAXHandler(HamNameMap hnmap) {
        this(new SiGMLResolver(), hnmap);
    }

    public HNSSignSAXHandler(CleanerEntityResolver er, HamNameMap hnmap) {
        super(er);
        this.hamNames = hnmap;
        this.hnsBuf = new StringBuilder(60);
        this.hnsManActive = false;
        this.hnsNonManActive = false;
        this.gloss = "";
        this.duration = null;
        this.speed = null;
        this.timescale = null;
    }

    public HNSSign getHNSSign() {
        return this.hnsSign;
    }

    public void startDocument() throws SAXException {
        this.gloss = null;
        this.duration = null;
        this.speed = null;
        this.timescale = null;
        this.manHNS = null;
        this.nonManHNS = null;
        this.hnsSign = null;
        this.hnsManActive = false;
        this.hnsNonManActive = false;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String nsuri, String localnm, String rawnm, Attributes attribs) throws SAXException {
        if (nsuri.length() != 0) {
            this.fatalFormatError("Non-null namespace-uri: " + nsuri);
        }
        if (localnm.equals(HNS_SIGN)) {
            this.gloss = attribs.getValue(GLOSS);
            this.duration = attribs.getValue(DURATION);
            this.speed = attribs.getValue(SPEED);
            this.timescale = attribs.getValue(TIMESCALE);
        } else if (localnm.equals(HNS_MAN)) {
            this.hnsManActive = true;
        } else if (localnm.equals(HNS_NONMAN)) {
            this.hnsNonManActive = true;
        } else if (this.hnsManActive) {
            int hns = this.hamNames.octet(localnm);
            if (0 <= hns) {
                this.hnsBuf.append((char)hns);
            } else {
                System.err.println("HNSSignSAXHandler: gloss=" + this.gloss + ", unrecognized HNS name: " + localnm);
            }
        } else if (this.hnsNonManActive) {
            this.saveNonManTag(localnm, attribs);
        }
    }

    public void endElement(String nsuri, String localnm, String rawnm) throws SAXException {
        if (localnm.equals(HNS_MAN)) {
            this.hnsManActive = false;
            this.manHNS = this.hnsBuf.toString();
            this.hnsBuf.setLength(0);
        } else if (localnm.equals(HNS_NONMAN)) {
            this.hnsNonManActive = false;
            this.nonManHNS = this.hnsBuf.toString();
            this.hnsBuf.setLength(0);
        } else if (localnm.equals(HNS_SIGN)) {
            boolean HAS_TIMING;
            this.hnsSign = new HNSSign(this.manHNS, this.nonManHNS, this.gloss, null);
            boolean bl = HAS_TIMING = this.duration != null || this.speed != null || this.timescale != null;
            if (HAS_TIMING) {
                this.hnsSign.setTiming(this.duration, this.speed, this.timescale);
            }
        }
    }

    protected void saveNonManTag(String nmtag, Attributes attribs) {
        String tag = HNSSiGMLNonManuals.hnsNMTokenForNMElement(nmtag, attribs);
        if (this.hnsBuf.length() != 0) {
            this.hnsBuf.append(' ');
        }
        this.hnsBuf.append(tag);
    }
}

