/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import hnscnvt.HNSSign;
import hnscnvt.HNSSignSAXHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sigmlgen.HNSSiGMLNonManuals;
import util.HamNameMap;
import xml.XMLScanner;

public class HNSSignElementToHNS {
    protected HamNameMap hamTokenMap = HamNameMap.getStdHamNameMap();
    protected XMLScanner hnsScanner;
    protected transient HNSSign hnsSign;

    public HNSSignElementToHNS() {
        try {
            this.hnsScanner = new XMLScanner("HNS-SIGN", false);
        }
        catch (XMLScanner.ScanException xssx) {
            System.out.println("####  HSNSignElementToHNS constructor: " + xssx);
        }
    }

    public HNSSign convert(String hnssigneltxt) {
        this.setHNSSignFromElement(hnssigneltxt);
        this.hnsSign.setElementText(hnssigneltxt);
        return this.hnsSign;
    }

    public HNSSign convert(Element hnssignel) {
        String gloss = hnssignel.getAttribute("gloss");
        if (gloss.length() == 0) {
            gloss = null;
        }
        String hnsman = this.getHNSManual(hnssignel);
        String hnsnonman = this.getHNSNonManual(hnssignel);
        this.hnsSign = new HNSSign(hnsman, hnsnonman, gloss, null);
        this.hnsSign.setElement(hnssignel);
        this.setTimingValuesForSign(hnssignel);
        return this.hnsSign;
    }

    protected void setHNSSignFromElement(String hnssigneltxt) {
        HNSSign sign = null;
        if (this.hnsScanner != null) {
            try {
                HNSSignSAXHandler hshndlr = new HNSSignSAXHandler(this.hamTokenMap);
                this.hnsScanner.scanXMLText(hnssigneltxt, hshndlr);
                sign = hshndlr.getHNSSign();
            }
            catch (XMLScanner.ScanException xssx) {
                System.out.println("####  HNSSignElementToHNS: " + xssx);
            }
        }
        this.hnsSign = sign == null ? new HNSSign() : sign;
    }

    protected String getHNSManual(Element hnssignel) {
        String man = null;
        Node manel = hnssignel.getElementsByTagName("hamnosys_manual").item(0);
        if (manel != null) {
            StringBuilder strbuf = new StringBuilder(48);
            NodeList mantags = manel.getChildNodes();
            int N = mantags.getLength();
            for (int i = 0; i != N; ++i) {
                Node nd = mantags.item(i);
                if (nd.getNodeType() != 1) continue;
                String hnstok = nd.getNodeName();
                int hnstag = this.hamTokenMap.octet(nd.getNodeName());
                strbuf.append((char)hnstag);
            }
            man = strbuf.toString();
            strbuf.setLength(0);
            strbuf = null;
        }
        return man;
    }

    protected String getHNSNonManual(Element hnssignel) {
        String nonman = null;
        Node nmel = hnssignel.getElementsByTagName("hamnosys_nonmanual").item(0);
        if (nmel != null) {
            StringBuilder strbuf = new StringBuilder(48);
            NodeList nmels = nmel.getChildNodes();
            int N = nmels.getLength();
            int ntoks = 0;
            for (int i = 0; i != N; ++i) {
                Node nd = nmels.item(i);
                if (nd.getNodeType() != 1) continue;
                String nmtok = HNSSiGMLNonManuals.hnsNMTokenForNMElement((Element)nd);
                strbuf.append(ntoks == 0 ? nmtok : ' ' + nmtok);
                ++ntoks;
            }
            nonman = strbuf.toString();
            strbuf.setLength(0);
            strbuf = null;
        }
        return nonman;
    }

    protected void setTimingValuesForSign(Element hnssignel) {
        String duration = hnssignel.getAttribute("duration");
        String speed = hnssignel.getAttribute("speed");
        String timescale = hnssignel.getAttribute("timescale");
        if (duration != null || speed != null || timescale != null) {
            this.hnsSign.setTiming(duration, speed, timescale);
        }
    }
}

