/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import hnscnvt.HNSSign;
import hnscnvt.HNSSignsHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import sigmlgen.HNSSiGMLNonManuals;
import util.AsciiIdMapper;
import util.HamNameMap;
import util.RE;
import util.TokenizedLinesReader;

public class HNSInputToHandler {
    public static boolean DO_ASCIIFIED_GLOSS = true;
    public static boolean HNS_INPUT_IS_MAC_ROMAN = false;
    protected static final String HNST_DELIMITER_CHARS_RE = "[ \t,\\[\\]]+";
    protected static final char COMMENT_CHAR = '#';
    protected static final String[][] hamSpellingFix = new String[][]{{"non_raised", null}, {"raised", "eRB"}, {"furrowed", "eFU"}};
    protected static final int sGLOSS = 0;
    protected static final int sNONMANUAL = 1;
    protected static final int sMANUAL = 2;
    protected static final int sINITIAL = 0;
    protected static final int sFINAL = 2;
    protected HNSSignsHandler hnsHandler;
    protected HamNameMap hnMap;
    protected AsciiIdMapper asciiMapper;
    protected int hnstLevel;
    protected int hnstStage;
    protected boolean hnstDoneBlock;
    protected int hnstCountExcessTokens;
    protected String hnstGloss;
    protected StringBuilder hnstManualBuf;
    protected StringBuilder hnstNonManualBuf;
    protected String[] hnstLine;
    protected int hnstLnNo;
    protected int hnstIndex;
    protected int hnstErrCount;
    protected boolean hnstDoWarn;
    protected int hecInit;
    protected String hnstErrorMessage;

    public HNSInputToHandler() {
        if (DO_ASCIIFIED_GLOSS) {
            this.asciiMapper = AsciiIdMapper.getAsciiIdMapper();
        }
    }

    public void inputStandardHNSFormatSigns(InputStream hamins, int limit, HNSSignsHandler hndlr) {
        try {
            InputStreamReader hamrdr = new InputStreamReader(hamins, "ISO-8859-1");
            this.inputStandardHNSFormatSigns(hamrdr, limit, hndlr);
        }
        catch (IOException x) {
            x.printStackTrace();
            System.exit(1);
        }
    }

    public void inputStandardHNSFormatSigns(String hns, int limit, HNSSignsHandler hndlr) {
        StringReader hamrdr = new StringReader(hns);
        this.inputStandardHNSFormatSigns(hamrdr, limit, hndlr);
    }

    public void inputStandardHNSFormatSigns(Reader hamrdr, int limit, HNSSignsHandler hndlr) {
        this.hnsHandler = hndlr;
        BufferedReader lnrdr = new BufferedReader(hamrdr);
        String hnsln = HNSInputToHandler.getNonCommentLine(lnrdr);
        for (int i = 0; i != limit && hnsln != null; ++i) {
            String[] hnsparts = this.splitHNSLine(hnsln);
            String man = hnsparts[1];
            String nonman = hnsparts[2];
            if (nonman.length() != 0) {
                nonman = this.normalizeHNSNonManual(nonman);
            }
            String gloss = hnsparts[0];
            if (DO_ASCIIFIED_GLOSS) {
                gloss = HNS_INPUT_IS_MAC_ROMAN ? this.asciiMapper.rawMactoAscii(gloss) : this.asciiMapper.toAscii(gloss);
            }
            HNSSign hnss = new HNSSign(man, nonman, gloss, null);
            this.hnsHandler.processHNSSign(hnss);
            hnsln = HNSInputToHandler.getNonCommentLine(lnrdr);
        }
        this.hnsHandler.doneAllHNSSigns();
    }

    public void inputHNSTFormatSigns(String hnsttxt, boolean warn, HNSSignsHandler hndlr) {
        StringReader hnstrdr = new StringReader(hnsttxt);
        this.inputHNSTFormatSigns(hnstrdr, warn, hndlr);
    }

    public void inputHNSTFormatSigns(InputStream ins, boolean warn, HNSSignsHandler hndlr) {
        try {
            InputStreamReader hnstrdr = new InputStreamReader(ins, "iso-8859-1");
            this.inputHNSTFormatSigns(hnstrdr, warn, hndlr);
        }
        catch (UnsupportedEncodingException uex) {
            uex.printStackTrace();
            System.exit(1);
        }
    }

    protected void inputHNSTFormatSigns(Reader hnstrdr, boolean warn, HNSSignsHandler hndlr) {
        this.hnsHandler = hndlr;
        this.hnstDoWarn = warn;
        if (this.hnMap == null) {
            this.hnMap = HamNameMap.getStdHamNameMap();
        }
        this.processHNSTStream(hnstrdr);
    }

    public int getHNSTErrorCount() {
        return this.hnstErrCount;
    }

    protected void processHNSTStream(Reader hnstrdr) {
        this.hnstLevel = 0;
        this.hnstLnNo = 0;
        this.hnstIndex = 0;
        this.hnstErrCount = 0;
        this.hnstDoneBlock = false;
        this.hnstCountExcessTokens = 0;
        this.hnstStage = -1;
        this.hnstGloss = null;
        this.hnstManualBuf = new StringBuilder(128);
        this.hnstNonManualBuf = new StringBuilder(128);
        TokenizedLinesReader hnstoks = new TokenizedLinesReader(hnstrdr, HNST_DELIMITER_CHARS_RE);
        this.hnstLine = hnstoks.getLineAsTokens();
        while (this.hnstLine != null) {
            ++this.hnstLnNo;
            if (!this.isSeparatorHNSTLine() && !this.isCommentHNSTLine()) {
                this.fixUpHNSTLine();
                this.hnstIndex = 0;
                for (String tok : this.hnstLine) {
                    this.processHNSToken(tok);
                    ++this.hnstIndex;
                }
            }
            this.hnstLine = hnstoks.getLineAsTokens();
        }
        this.hnsHandler.doneAllHNSSigns();
        if (this.hnstCountExcessTokens != 0) {
            this.hnstWarn("Excess tokens at end of input, count=" + this.hnstCountExcessTokens + ".");
        } else if (this.hnstLevel != 0) {
            this.hnstWarn("bad final level (" + this.hnstLevel + ").");
        }
    }

    protected boolean isSeparatorHNSTLine() {
        return this.hnstLine.length == 1 ? this.hnstLine[0].startsWith("----") : false;
    }

    protected boolean isCommentHNSTLine() {
        int idone = this.hnstLine.length;
        int i = 0;
        boolean cfound = false;
        while (i != idone) {
            char ch0 = this.hnstLine[i].charAt(0);
            if (ch0 == ' ' | ch0 == '\t') {
                ++i;
                continue;
            }
            idone = i;
            cfound = ch0 == '#';
        }
        return cfound;
    }

    protected void fixUpHNSTLine() {
        ArrayList<String> newtoks = new ArrayList<String>(this.hnstLine.length + 5);
        for (String tok : this.hnstLine) {
            if (tok != null) {
                tok = HNSInputToHandler.fixHamSpelling(tok);
            }
            if (tok == null) continue;
            newtoks.add(tok);
        }
        this.hnstLine = newtoks.toArray(new String[0]);
    }

    protected void processHNSToken(String tok) {
        char ch0 = tok.charAt(0);
        if (this.hnstDoneBlock) {
            if (!Character.isWhitespace(ch0)) {
                ++this.hnstCountExcessTokens;
            }
        } else if (Character.isLetter(tok.charAt(0))) {
            this.processIdToken(tok);
        } else if (tok.length() == 1) {
            if (!Character.isWhitespace(ch0) && ch0 != ',') {
                if (ch0 == '[') {
                    this.processLBracketToken();
                } else if (ch0 == ']') {
                    this.processRBracketToken();
                } else {
                    this.hnstWarn("Unknown HNS token.");
                }
            }
        } else {
            this.hnstWarn("Unknown HNS token");
        }
    }

    protected void processLBracketToken() {
        ++this.hnstLevel;
        if (this.hnstLevel < 1) {
            this.hnstWarn("negative scan level PANIC");
        } else if (3 < this.hnstLevel) {
            this.hnstWarn("over-high scan level (" + this.hnstLevel + ").");
        } else if (2 == this.hnstLevel) {
            this.hecInit = this.hnstErrCount;
            this.hnstStage = -1;
            this.hnstGloss = null;
            this.hnstManualBuf.setLength(0);
            this.hnstNonManualBuf.setLength(0);
        } else if (3 == this.hnstLevel) {
            ++this.hnstStage;
            if (2 < this.hnstStage) {
                this.hnstWarn("scan extra '['-list.");
            }
        }
    }

    protected void processRBracketToken() {
        if (this.hnstLevel == 0) {
            this.hnstWarn("scan extra ']'");
        } else {
            --this.hnstLevel;
            if (this.hnstLevel == 0) {
                this.hnstDoneBlock = true;
            } else if (this.hnstLevel == 1) {
                if (this.hnstStage != 2) {
                    String msgstart = "incomplete sign (stage=";
                    String msg = msgstart + this.hnstStage + ").";
                    this.hnstWarn(msg);
                }
                String man = this.hnstManualBuf.toString();
                String nonman = this.hnstNonManualBuf.toString();
                int ec = this.hnstErrCount - this.hecInit;
                String emsg = ec == 0 ? null : this.hnstErrorMessage;
                String gloss = this.hnstGloss;
                if (DO_ASCIIFIED_GLOSS) {
                    gloss = this.asciiMapper.toAscii(gloss);
                }
                HNSSign hnss = new HNSSign(man, nonman, gloss, emsg);
                this.hnsHandler.processHNSSign(hnss);
                this.hnstGloss = null;
                this.hnstManualBuf.setLength(0);
                this.hnstNonManualBuf.setLength(0);
            }
        }
    }

    protected void processIdToken(String tok) {
        if (this.hnstLevel != 3) {
            this.hnstWarn("identifier at wrong level (" + this.hnstLevel + ").");
        } else if (this.hnstStage == 0) {
            if (this.hnstGloss != null) {
                this.hnstWarn("extra gloss after " + this.hnstGloss + ".");
            } else {
                this.hnstGloss = tok;
            }
        } else if (this.hnstStage == 1) {
            this.processNonManualToken(tok);
        } else if (this.hnstStage == 2) {
            if (!tok.startsWith("ham")) {
                this.hnstWarn("token starts without \"ham\".");
            } else {
                int ch = this.hnMap.octet(tok);
                if (ch < 0) {
                    this.hnstWarn("unknown identifier.");
                } else {
                    this.hnstManualBuf.append((char)(ch & 0xFF));
                }
            }
        }
    }

    protected void processNonManualToken(String tok) {
        String newnm = HNSSiGMLNonManuals.checkAndNormalizeNMTag(tok);
        if (newnm == null) {
            this.hnstWarn("invalid non-manual.");
        } else {
            if (this.hnstNonManualBuf.length() != 0) {
                this.hnstNonManualBuf.append(' ');
            }
            this.hnstNonManualBuf.append(newnm);
        }
    }

    protected void hnstWarn(String msg) {
        ++this.hnstErrCount;
        if (this.hnstDoWarn) {
            String msgbase = "HNST error, line=" + this.hnstLnNo + ", ";
            String msgix = "index=" + this.hnstIndex + " ";
            String msgtok = this.hnstLine == null ? ": " : "(token=" + this.hnstLine[this.hnstIndex] + "): ";
            String msgall = msgbase + msgix + msgtok + msg;
            System.err.println(msgall);
            if (this.hecInit + 1 == this.hnstErrCount) {
                this.hnstErrorMessage = msgall;
            }
        }
    }

    protected String normalizeHNSNonManual(String nonman) {
        String COMMA_OR_SPACE = RE.tag(RE.or(",", "\\s"));
        String NON_MAN_SEPARATOR = RE.seqNE(COMMA_OR_SPACE);
        String[] nmtoks = nonman.split(NON_MAN_SEPARATOR);
        int N = nmtoks.length;
        String result = null;
        if (N != 0) {
            StringBuilder sbuf = new StringBuilder(N * 5);
            for (String nmtok : nmtoks) {
                String nm = HNSSiGMLNonManuals.checkAndNormalizeNMTag(nmtok);
                if (nm == null) continue;
                if (sbuf.length() != 0) {
                    sbuf.append(" ");
                }
                sbuf.append(nm);
            }
            result = sbuf.toString();
        }
        return result;
    }

    protected String[] splitHNSLine(String hnsln) {
        String LH_SB = "\\[";
        String RH_SB = "\\]";
        String NON_RH_SB_OPT = RE.seq(RE.notChr("\\]"));
        String GLOSS = RE.tag(RE.NON_TABSP);
        String MAN = RE.tag(RE.notChr("\\[") + RE.NON_TABSP_OPT);
        String NON_MAN = "\\[" + RE.tag(NON_RH_SB_OPT) + "\\]";
        String TAIL_OPT = RE.seq(".");
        String HNS_LINE = RE.opt(GLOSS) + RE.TABSP + RE.tag(RE.or(RE.tag(NON_MAN), RE.tag(MAN + RE.opttag(RE.TABSP + NON_MAN)))) + TAIL_OPT;
        boolean GLOSS_GP = true;
        int NON_MAN_SOLO_GP = 4;
        int MAN_GP = 6;
        int NON_MAN_OPT_GP = 8;
        String gloss = "";
        String man = "";
        String nonman = "";
        Matcher mtchr = RE.matcher(HNS_LINE, hnsln);
        if (mtchr.matches()) {
            String gnms;
            String ggloss = mtchr.group(1);
            if (ggloss != null) {
                gloss = ggloss;
            }
            if ((gnms = mtchr.group(4)) != null) {
                nonman = gnms.trim();
            } else {
                man = mtchr.group(6);
                String gnonman = mtchr.group(8);
                if (gnonman != null) {
                    nonman = gnonman.trim();
                }
            }
        }
        String[] result = new String[]{gloss, man, nonman};
        return result;
    }

    protected static String fixHamSpelling(String htok) {
        int lim = hamSpellingFix.length;
        int i = 0;
        while (i != lim) {
            boolean match = htok.equals(hamSpellingFix[i][0]);
            if (match) {
                lim = i;
                continue;
            }
            ++i;
        }
        return i != hamSpellingFix.length ? hamSpellingFix[i][1] : htok;
    }

    protected static String getNonCommentLine(BufferedReader lnrdr) {
        String ln = HNSInputToHandler.getLine(lnrdr);
        String lnfinal = null;
        while (ln != lnfinal) {
            boolean cline;
            String tln = ln.trim();
            boolean bl = cline = tln.charAt(0) == '#';
            if (cline) {
                ln = HNSInputToHandler.getLine(lnrdr);
                continue;
            }
            lnfinal = ln;
        }
        return ln;
    }

    protected static String getLine(BufferedReader lnrdr) {
        String ln = null;
        try {
            ln = lnrdr.readLine();
        }
        catch (IOException iox) {
            System.out.println("HNSInputToHandler: " + iox.getMessage());
        }
        return ln;
    }
}

