/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import hnscnvt.HNSInputToHandler;
import hnscnvt.HNSSign;
import hnscnvt.HNSSignToElementText;
import hnscnvt.HNSSignsHandler;
import java.util.ArrayList;
import sigmlgen.SiGMLTagDefs;
import util.StringUtils;

public abstract class HNSInputAsSignSequence {
    protected HNSSign[] hnsSigns;
    protected String[] glosses;
    protected String[] sigmlHNSSignElTexts;
    protected String inErrorText;
    protected int inErrorCount;
    protected HNSInputToHandler hnsInputter = new HNSInputToHandler();
    protected HNSSignsHandler signsHandler = new HNSHandler();

    public HNSInputAsSignSequence(String hnstext) {
        this.doHNSInput(hnstext == null ? "" : hnstext);
    }

    protected abstract void doHNSInput(String var1);

    public HNSSign[] hnsSignSequence() {
        return this.hnsSigns;
    }

    public String[] sigmlHNSSigns() {
        return this.sigmlHNSSignElTexts;
    }

    public String[] signGlosses() {
        return this.glosses;
    }

    public String sigmlErrorText() {
        return this.inErrorText;
    }

    public int sigmlInputErrorCount() {
        return this.inErrorCount;
    }

    protected void setHNSData(HNSSign[] hnssigns, int nerrs) {
        int N = hnssigns.length;
        this.hnsSigns = hnssigns;
        this.glosses = new String[N];
        this.inErrorCount = nerrs;
        this.inErrorText = "";
        StringBuilder errbuf = new StringBuilder(100 * nerrs);
        if (this.inErrorCount != 0) {
            errbuf.append("####  HNS-Input errors ..." + StringUtils.EOL);
        }
        this.sigmlHNSSignElTexts = new String[N];
        HNSSignToElementText signtoel = new HNSSignToElementText();
        for (int i = 0; i != N; ++i) {
            HNSSign sign = this.hnsSigns[i];
            String GLOSS = this.glosses[i] = sign.gloss();
            if (sign.error() == null) {
                String eltext = signtoel.hnsSignElement(sign);
                sign.setElementText(eltext);
                this.sigmlHNSSignElTexts[i] = eltext;
                continue;
            }
            this.sigmlHNSSignElTexts[i] = SiGMLTagDefs.emptyHNSSignText(GLOSS);
            errbuf.append("HNS-Index=").append(i).append(", Gloss=").append(GLOSS).append(':').append(StringUtils.EOL).append(sign.error()).append(StringUtils.EOL);
            sign.setMan("");
            sign.setNonMan("");
        }
        if (this.inErrorCount != 0) {
            this.inErrorText = errbuf.toString();
        }
    }

    private class HNSHandler
    implements HNSSignsHandler {
        private ArrayList<HNSSign> hnsSignList = new ArrayList(50);
        private int errCount = 0;

        public void doneAllHNSSigns() {
            int N = this.hnsSignList.size();
            HNSSign[] hsigns = new HNSSign[N];
            this.hnsSignList.toArray(hsigns);
            HNSInputAsSignSequence.this.setHNSData(hsigns, this.errCount);
            this.hnsSignList.clear();
            this.hnsSignList = null;
        }

        public void processHNSSign(HNSSign hnss) {
            this.hnsSignList.add(hnss);
            if (hnss.error() != null) {
                ++this.errCount;
            }
        }
    }
}

