/*
 * Decompiled with CFR 0.152.
 */
package hnscnvt;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sigmlgen.HSDocParameters;
import sigmlgen.SiGMLResolver;
import sigmlgen.xslth4.H2SAccess;
import xml.CleanerEntityResolver;
import xml.InvalidXMLException;
import xml.XmlElementTextGen;
import xml.XmlValidator;

public class HMLToSiGML {
    protected Transformer h2sXformer;
    protected XmlElementTextGen textGenerator;

    public HMLToSiGML() throws HMLToSiGMLException {
        String h2saddr = HSDocParameters.getH2SSignsURI(null);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StreamSource h2ssrc = new StreamSource(H2SAccess.xsltReader(h2saddr));
        try {
            Templates templates = tfactory.newTemplates(h2ssrc);
            this.h2sXformer = templates.newTransformer();
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("H2S transform set up for " + h2saddr, tcx);
        }
        try {
            this.textGenerator = new XmlElementTextGen(true);
        }
        catch (TransformerConfigurationException tcx) {
            this.fail("XmlElementTextGen creation fails", tcx);
        }
    }

    public String sigmlSignAsDoc(String sigmlsign) {
        return HSDocParameters.wrapSiGMLDocBodyEls(sigmlsign);
    }

    public String sigmlSignText(Element sigmlsel) throws HMLToSiGMLException {
        String sigmltxt = null;
        try {
            sigmltxt = this.textGenerator.getText(sigmlsel);
        }
        catch (TransformerException tx) {
            this.fail("SiGML text generation failure", tx);
        }
        return sigmltxt;
    }

    public String sigmlSignTextForHML(String hmlstxt) throws HMLToSiGMLException {
        StringReader hrdr = new StringReader(hmlstxt);
        StreamSource hmlsrc = new StreamSource(hrdr);
        DOMResult ssrslt = new DOMResult();
        this.generateSiGMLSign(hmlsrc, (Result)ssrslt);
        Document ssdoc = (Document)ssrslt.getNode();
        Element ssel = ssdoc.getDocumentElement();
        return this.sigmlSignText(ssel);
    }

    public String sigmlSignTextForHML(Element hmlsel) throws HMLToSiGMLException {
        Element sigmlsel = this.sigmlSignForHML(hmlsel);
        return this.sigmlSignText(sigmlsel);
    }

    public Element sigmlSignForHML(Element hmlsel) throws HMLToSiGMLException {
        DOMResult ssrslt = new DOMResult();
        this.generateSiGMLSign(hmlsel, (Result)ssrslt);
        Document ssdoc = (Document)ssrslt.getNode();
        Element ssel = ssdoc.getDocumentElement();
        return ssel;
    }

    public void validateSiGML(String sdoctxt, boolean emptywsok) throws HMLToSiGMLException {
        try {
            String sdoc = emptywsok ? sdoctxt.replaceAll(">[\\s]+<", "><") : sdoctxt;
            XmlValidator xv = new XmlValidator();
            StringReader srdr = new StringReader(sdoc);
            InputSource ins = new InputSource(srdr);
            xv.validate(ins, (CleanerEntityResolver)new SiGMLResolver());
        }
        catch (ParserConfigurationException pcx) {
            this.fail("parser config. error", pcx);
        }
        catch (InvalidXMLException ixx) {
            this.fail("SiGML invalid", ixx);
        }
        catch (SAXException sx) {
            this.fail("SAX error", sx);
        }
        catch (IOException iox) {
            this.fail("IO Error", iox);
        }
    }

    public void validateSiGML(String sdoctxt) throws HMLToSiGMLException {
        this.validateSiGML(sdoctxt, false);
    }

    protected void generateSiGMLSign(Element hmlsel, Result ssrslt) throws HMLToSiGMLException {
        DOMSource hssrc = new DOMSource(hmlsel);
        this.generateSiGMLSign(hssrc, ssrslt);
    }

    protected void generateSiGMLSign(Source hssrc, Result ssrslt) throws HMLToSiGMLException {
        try {
            this.h2sXformer.transform(hssrc, ssrslt);
        }
        catch (TransformerException tx) {
            String msg = "HML-to-SiGML transform error";
            this.fail(msg, tx);
        }
    }

    protected void fail(String msg, Exception x) throws HMLToSiGMLException {
        String fullmsg = msg + ": " + x.getMessage();
        throw new HMLToSiGMLException(fullmsg);
    }

    public static class HMLToSiGMLException
    extends Exception {
        public HMLToSiGMLException(String msg) {
            super(msg);
        }
    }
}

