/*
 * Decompiled with CFR 0.152.
 */
package hamwalk;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMLBuilder {
    protected DocumentBuilder docBuilder;
    protected Document doc;

    public HMLBuilder() throws IOException, DOMException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.docBuilder = dbf.newDocumentBuilder();
        this.doc = this.docBuilder.newDocument();
    }

    public HMLBuilder(DocumentBuilder bldr) {
        this.docBuilder = bldr;
        this.doc = this.docBuilder.newDocument();
    }

    public Element newHMLElement(String tag) {
        return this.doc.createElement(tag);
    }

    public Attr newHMLAttr(String aname) {
        return this.doc.createAttribute(aname);
    }

    public Comment newHMLComment(String data) {
        return this.doc.createComment(data);
    }

    public Element wrapperEl(String tag, Element inner) {
        Element wel = this.doc.createElement(tag);
        wel.appendChild(inner);
        return wel;
    }

    public Element wrapPair(String tag, Element inner0, Element inner1) {
        Element wel = this.wrapperEl(tag, inner0);
        wel.appendChild(inner1);
        return wel;
    }

    public Element wrapIfNeeded(String tag, Element el) {
        String elTag = el.getTagName();
        boolean elIsOK = elTag.equals(tag) && el.getAttributes().getLength() == 0;
        return elIsOK ? el : this.wrapperEl(tag, el);
    }

    public Element stripParentIfNotNeeded(Element el) {
        Element result = el;
        Element child = (Element)el.getFirstChild();
        if (el.getTagName().equals(child.getTagName()) && el.getAttributes().getLength() == 0) {
            result = (Element)el.removeChild(child);
        }
        return result;
    }

    public Element elementFromList(ArrayList<Element> al, String etag) {
        Element[] el = al.toArray(new Element[0]);
        Element e = null;
        if (el.length == 1) {
            e = el[0];
        } else {
            e = this.newHMLElement(etag);
            for (Element elmem : el) {
                e.appendChild(elmem);
            }
        }
        return e;
    }

    public void insertNonManual(Element signel, Element nmel) {
        if (nmel != null) {
            signel.insertBefore(nmel, signel.getFirstChild());
        }
    }

    public void setDocRoot(Element root) {
        this.doc.appendChild(root);
    }

    public Element parseElement(String eltext) {
        Element el = null;
        if (!eltext.equals("")) {
            StringReader elrdr = new StringReader(eltext);
            InputSource elsrc = new InputSource(elrdr);
            try {
                Document eldoc = this.docBuilder.parse(elsrc);
                Element alienel = eldoc.getDocumentElement();
                el = (Element)this.doc.importNode(alienel, true);
            }
            catch (SAXException sx) {
                System.out.println(sx.getMessage());
            }
            catch (IOException iox) {
                System.out.println(iox.getMessage());
            }
        }
        return el;
    }

    public static void checkedAppendChild(Element el, Element ch) {
        if (ch != null) {
            el.appendChild(ch);
        }
    }

    public static void appendChildList(Element el, Element[] chl) {
        for (Element chel : chl) {
            el.appendChild(chel);
        }
    }

    public static void checkedSetAttr(Element el, String aname, String aval) {
        if (aval != null) {
            el.setAttribute(aname, aval);
        }
    }

    public static void checkedSetFlagAttr(Element el, String aname, boolean flagIsTrue) {
        if (flagIsTrue) {
            el.setAttribute(aname, "true");
        }
    }

    public static void checkedStringSetFlagAttr(Element el, String aname, String aval) {
        if (aval != null && aval.equals("true")) {
            el.setAttribute(aname, "true");
        }
    }

    public LSSerializer getLSSerializer() {
        DOMImplementation dimpl = this.doc.getImplementation();
        DOMImplementationLS domls = (DOMImplementationLS)dimpl.getFeature("LS", "3.0");
        return domls.createLSSerializer();
    }
}

