/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.SeqNumberGenerator;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimerDisplay
extends JFrame {
    private static final Font LABEL_FONT = new Font("Monospaced", 1, 24);
    private SeqNumberGenerator seqNoGen;
    private JLabel lblMinutes;
    private JLabel lblSecs;
    private JLabel lblTenths;
    private JLabel lblSeqNo;

    public TimerDisplay() {
        this("Timer", false);
    }

    public TimerDisplay(String title, boolean exit) {
        this(title, exit, null);
    }

    public TimerDisplay(String title, boolean exit, SeqNumberGenerator sng) {
        this.seqNoGen = sng;
        this.lblMinutes = TimerDisplay.newLabel("00", true);
        this.lblSecs = TimerDisplay.newLabel("00", true);
        this.lblTenths = TimerDisplay.newLabel("0", true);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new FlowLayout());
        content.add(TimerDisplay.newLabel("Clk", false));
        content.add(TimerDisplay.newLabel("=", false));
        content.add(this.lblMinutes);
        content.add(TimerDisplay.newLabel(":", false));
        content.add(this.lblSecs);
        content.add(TimerDisplay.newLabel(".", false));
        content.add(this.lblTenths);
        if (this.seqNoGen != null) {
            this.lblSeqNo = TimerDisplay.newLabel("00000000", true);
            content.add(TimerDisplay.newLabel("  Pkt-Seq-No", false));
            content.add(TimerDisplay.newLabel("=", false));
            content.add(this.lblSeqNo);
        }
        if (exit) {
            this.setDefaultCloseOperation(3);
        }
        this.setSize(656, 88);
        this.setTitle(title);
        this.setVisible(true);
    }

    public void setTime(int m, int s, int t) {
        this.lblMinutes.setText(TimerDisplay.str2(m));
        this.lblSecs.setText(TimerDisplay.str2(s));
        this.lblTenths.setText(TimerDisplay.str1(t));
        if (this.seqNoGen != null) {
            this.lblSeqNo.setText(TimerDisplay.str8(this.seqNoGen.peekNext()));
        }
    }

    private static JLabel newLabel(String txt, boolean rjust) {
        int align = rjust ? 4 : 0;
        JLabel lbl = new JLabel(txt, align);
        lbl.setFont(LABEL_FONT);
        lbl.setForeground(new Color(0, 0, 224));
        if (rjust) {
            lbl.setBackground(Color.WHITE);
        }
        return lbl;
    }

    private static String str2(int n) {
        String s = "00" + n;
        int len = s.length();
        return s.substring(len - 2);
    }

    private static String str1(int n) {
        String s = "0" + n;
        int len = s.length();
        return s.substring(len - 1);
    }

    private static String str8(int n) {
        String s = "00000000" + n;
        int len = s.length();
        return s.substring(len - 8);
    }
}

