/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.TimerDisplay;

public class TimeKeeper {
    protected static final long TICK_MILLIS = 10L;
    public long clock;
    protected Thread ticker;
    protected boolean killed;
    protected long sysTimeZero;
    protected int countWaiting;
    protected long nextWakeUpTime;
    protected TimerDisplay display;

    public TimeKeeper(long tnowmillis, TimerDisplay disp) {
        this.display = disp;
        this.clock = tnowmillis;
        this.sysTimeZero = System.currentTimeMillis() - this.clock;
        this.killed = false;
        this.countWaiting = 0;
        this.ticker = new Thread(){

            public void run() {
                TimeKeeper.this.runClock();
            }
        };
        this.ticker.start();
    }

    public TimeKeeper(long tnowmillis) {
        this(tnowmillis, null);
    }

    public synchronized void kill() {
        this.killed = true;
    }

    public void delaySecs(long nsecs) {
        this.waitUntil(this.clock + nsecs * 1000L);
    }

    public void delayTicks(long nticks) {
        this.waitUntil(this.clock + nticks * 10L);
    }

    public void delay(long nmillis) {
        this.waitUntil(this.clock + nmillis);
    }

    public void waitUntilSecs(long nsecs) {
        this.waitUntil(nsecs * 1000L);
    }

    public void waitUntilTicks(long nticks) {
        this.waitUntil(nticks * 10L);
    }

    public synchronized void waitUntil(long tmillis) {
        long tcontinue = tmillis;
        while (this.clock < tcontinue && !this.killed) {
            if (this.countWaiting == 0 || tcontinue < this.nextWakeUpTime) {
                this.nextWakeUpTime = tcontinue;
            }
            ++this.countWaiting;
            try {
                this.wait();
            }
            catch (InterruptedException ix) {
                --this.countWaiting;
                tcontinue = this.clock;
            }
        }
    }

    protected void runClock() {
        while (!this.killed) {
            long tnext = this.sysTimeZero + this.clock + 10L;
            long delay = tnext - System.currentTimeMillis();
            if (0L < delay) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
            }
            this.clock += 10L;
            this.doDisplay();
            this.reviewWaitingThreads();
        }
        this.releaseAll();
    }

    protected synchronized void reviewWaitingThreads() {
        if (0 < this.countWaiting && this.nextWakeUpTime <= this.clock) {
            this.releaseAll();
        }
    }

    protected synchronized void releaseAll() {
        this.countWaiting = 0;
        this.notifyAll();
    }

    protected void doDisplay() {
        int ms;
        int tx;
        if (this.display != null && (tx = (ms = (int)(this.clock % 1000L)) % 100) == 0) {
            int t = ms / 100;
            long ss = this.clock / 1000L;
            int s = (int)(ss % 60L);
            int m = (int)(ss / 60L);
            this.display.setTime(m, s, t);
        }
    }
}

