/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.BPSTransmitter;
import broadcast.PacketSender;
import broadcast.SegmentSender;
import broadcast.SiGMLSegmentTransmitter;
import broadcast.SiGMLStreamHandler;
import broadcast.SiGMLStreamNotify;
import broadcast.TimeKeeper;
import java.io.File;
import java.io.IOException;
import org.xml.sax.helpers.DefaultHandler;
import sigmlinlib.SIDefs;
import util.ReaderLinesTracker;
import util.StringUtils;
import xml.XMLScanner;

public class SiGMLStreamTransmitter
extends XMLScanner
implements SiGMLStreamNotify {
    public static final String TESTFILE = "testsstream.sigml";
    public static final int BS_PORT_BASE = SIDefs.inPort(3, -1);
    public static final long LEAD_MILLIS = 200L;
    protected String inputURI;
    protected SiGMLStreamHandler ssHandler;
    protected ReaderLinesTracker sigmlTracker;
    protected SegmentSender sigmlSender;
    protected PacketSender pktSender;
    protected TimeKeeper timer;
    public static final String XMIT_PREFIX = "####  SiGML Stream XMIT ";

    public static void main(String[] args) throws IOException, XMLScanner.ScanException {
        String path = TESTFILE;
        int bspbase = -1;
        if (args != null && args.length != 0) {
            if (2 < args.length) {
                SiGMLStreamTransmitter.abort();
            }
            path = args[0];
            if (args.length == 2 && (bspbase = StringUtils.nnVal(args[1], null)) < 0) {
                SiGMLStreamTransmitter.abort();
            }
        }
        SiGMLStreamTransmitter xmitter = new SiGMLStreamTransmitter(path, bspbase);
    }

    private static void abort() {
        SiGMLStreamTransmitter.usage();
        System.exit(1);
    }

    private static void usage() {
        String umsg = "usage: broadcast.SiGMLStreamTransmitter [sigml-stream-file [udp-port-base]]";
        System.out.println(umsg);
    }

    public SiGMLStreamTransmitter(String path) throws IOException, XMLScanner.ScanException {
        this(path, BS_PORT_BASE);
    }

    public SiGMLStreamTransmitter(String path, int bsportbase) throws IOException, XMLScanner.ScanException {
        super("SIGML-STREAM");
        String inuri;
        File inf = new File(path).getCanonicalFile();
        this.inputURI = inuri = inf.toURL().toString();
        this.setUpSiGMLSender(bsportbase);
        this.ssHandler = new SiGMLStreamHandler(this.inputURI, this);
        this.sigmlTracker = new ReaderLinesTracker(inf);
        this.scanXML(this.inputURI, (DefaultHandler)this.ssHandler);
        System.out.println("####  SiGML parse done.");
        this.shutDownSiGMLSender();
        System.out.println("####  SiGML Stream transmitter done.");
    }

    protected void setUpSiGMLSender(int bsportbase) throws IOException {
        this.timer = new TimeKeeper(-200L);
        this.pktSender = new BPSTransmitter(bsportbase);
        this.sigmlSender = new SiGMLSegmentTransmitter(this.timer, this.pktSender);
    }

    protected void shutDownSiGMLSender() {
        while (!this.sigmlSender.doneSegmentSequenceSend()) {
            this.timer.delayTicks(25L);
        }
        this.sigmlSender.kill();
        this.timer.delay(100L);
        this.timer.kill();
        this.pktSender.kill();
    }

    public void noteSiGMLStreamStart() {
        this.sigmlSender.addStarterToQueue();
        System.out.println("####  SiGML Stream XMIT started.");
    }

    public void noteSiGMLStreamDone(long totalclk) {
        this.sigmlSender.addTerminatorToQueue(totalclk);
        this.sigmlTracker.close();
        String msg = "####  SiGML Stream XMIT done, total-clk=" + totalclk;
        System.out.println(msg);
    }

    public void noteSiGMLSection(int lnPrev, int colPrev, int lnSSegStart, int colSSegStart, int lnSSegEnd, int colSSegEnd, long prsntclk) {
        this.sigmlTracker.advanceFront(lnSSegEnd, colSSegEnd);
        int i = lnPrev;
        int j = this.sigmlTracker.findInLine(i, "<sigmlsection");
        while (j < 0) {
            j = this.sigmlTracker.findInLine(++i, "<sigmlsection");
        }
        String[] seglns = this.sigmlTracker.segment(i, j, lnSSegEnd, colSSegEnd);
        this.sigmlTracker.advanceBack(lnSSegEnd, colSSegEnd);
        String sgmtmsg = "####  SiGML Stream XMIT segment:  ln-count=" + seglns.length + "  present-clk=" + prsntclk;
        System.out.println(sgmtmsg);
        this.sigmlSender.addSegmentToSendQueue(seglns, prsntclk);
    }
}

