/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.SiGMLStreamNotify;
import java.util.regex.Matcher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import sigmlgen.SiGMLResolver;
import util.RE;
import xml.BasicSAXHandler;
import xml.CleanerEntityResolver;

public class SiGMLStreamHandler
extends BasicSAXHandler {
    protected static final String BLANK = "".intern();
    protected static final String SIGML_STREAM = "sigmlstream".intern();
    protected static final String SIGML_SECTION = "sigmlsection".intern();
    protected static final String DURATION = "duration".intern();
    protected static final String PRESENT = "present".intern();
    protected String inputURI;
    protected SiGMLStreamNotify ssNotify;
    protected int lnPrev;
    protected int colPrev;
    protected int lnSSegStart;
    protected int colSSegStart;
    protected int lnSSegEnd;
    protected int colSSegEnd;
    protected String ssPresent;
    protected long ssPresentClk;
    protected String ssDuration;
    protected long ssDurationClk;

    public SiGMLStreamHandler(String inuri, SiGMLStreamNotify ntfy) {
        this(inuri, new SiGMLResolver(), ntfy);
    }

    public SiGMLStreamHandler(String inuri, CleanerEntityResolver er, SiGMLStreamNotify ntfy) {
        super(er);
        this.inputURI = inuri;
        this.ssNotify = ntfy;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String nsuri, String localnm, String rawnm, Attributes attribs) throws SAXException {
        if (nsuri != BLANK) {
            this.fatalFormatError("Non-null namespace-uri: " + nsuri);
        }
        if (localnm == SIGML_STREAM) {
            this.lnPrev = this.xmlLocator.getLineNumber();
            this.colPrev = this.xmlLocator.getColumnNumber();
            this.ssDuration = attribs.getValue(DURATION);
            this.ssDurationClk = SiGMLStreamHandler.clockValue(this.ssDuration);
            this.ssNotify.noteSiGMLStreamStart();
        } else if (localnm == SIGML_SECTION) {
            this.lnSSegStart = this.xmlLocator.getLineNumber();
            this.colSSegStart = this.xmlLocator.getColumnNumber();
            this.ssPresent = attribs.getValue(PRESENT);
            this.ssPresentClk = SiGMLStreamHandler.clockValue(this.ssPresent);
            if (this.ssPresentClk < 0L) {
                this.fatalFormatError("bad presentation time");
            }
        }
    }

    public void endElement(String nsuri, String localnm, String rawnm) throws SAXException {
        if (localnm == SIGML_SECTION) {
            this.lnSSegEnd = this.xmlLocator.getLineNumber();
            this.colSSegEnd = this.xmlLocator.getColumnNumber();
            this.ssNotify.noteSiGMLSection(this.lnPrev, this.colPrev, this.lnSSegStart, this.colSSegStart, this.lnSSegEnd, this.colSSegEnd, this.ssPresentClk);
            this.lnPrev = this.lnSSegEnd;
            this.colPrev = this.colSSegEnd;
        } else if (localnm == SIGML_STREAM) {
            this.ssNotify.noteSiGMLStreamDone(this.ssDurationClk);
        }
    }

    public static long presentClockForSection(String sect) {
        int i = sect.indexOf(62);
        String stag = sect.substring(0, i + 1);
        RE.AV avp = RE.findAVq(stag, PRESENT, RE.STRING);
        String sprsnt = avp == null ? "" : avp.val;
        return SiGMLStreamHandler.clockValue(sprsnt);
    }

    protected static long clockValue(String clkstr) {
        Matcher mtchr;
        String reDD = "\\d\\d";
        String rePresent = RE.tag(reDD) + ":" + RE.tag(reDD) + ":" + RE.tag(reDD) + "." + RE.tag(reDD);
        long clk = 0L;
        if (clkstr != null && (mtchr = RE.matcher(rePresent, clkstr)).lookingAt()) {
            String hstr = mtchr.group(1);
            String mstr = mtchr.group(2);
            String msstr = mtchr.group(3) + mtchr.group(4) + "0";
            try {
                int hrs = Integer.parseInt(hstr, 10);
                int mins = Integer.parseInt(mstr, 10);
                int millis = Integer.parseInt(msstr, 10);
                clk = (hrs * 60 + mins) * 60 * 1000 + millis;
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
        }
        return clk;
    }
}

