/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.BroadcastSiGMLDefs;
import broadcast.PacketHeader;
import broadcast.PacketSendException;
import broadcast.PacketSender;
import broadcast.SegmentSendDescriptor;
import broadcast.SegmentSender;
import broadcast.SeqNumberGenerator;
import broadcast.TimeKeeper;
import java.util.LinkedList;

public class SiGMLSegmentTransmitter
implements SegmentSender {
    protected static final int MAX_BYTES_PER_MS = 12;
    protected static final long TICKS_PER_FRAME = 4L;
    protected static final long RCV_LEAD_MILLIS = 200L;
    protected static final String[] STARTER_SEGMENT = BroadcastSiGMLDefs.STARTER_SEGMENT;
    protected static final String[] TERMINATOR_SEGMENT = BroadcastSiGMLDefs.TERMINATOR_SEGMENT;
    protected static final int SEQ_NO_LIMIT = 100000000;
    protected TimeKeeper timer;
    protected PacketSender pktSender;
    protected SeqNumberGenerator seqNoGen;
    protected SegmentQueue sgmtQ;
    protected Thread sendThread;
    protected int countSegmentsQueued;
    protected boolean doneAddTerminatorToQueue;
    protected int countSegmentsSent;
    protected boolean killed;

    public SiGMLSegmentTransmitter(TimeKeeper tk, PacketSender pktsndr) {
        this.timer = tk;
        this.pktSender = pktsndr;
        this.seqNoGen = new SeqNumberGenerator(100000000);
        this.sgmtQ = new SegmentQueue();
        this.countSegmentsQueued = 0;
        this.countSegmentsSent = 0;
        this.doneAddTerminatorToQueue = false;
        this.killed = false;
        this.sendThread = new Thread(){

            public void run() {
                SiGMLSegmentTransmitter.this.runSender();
            }
        };
        this.sendThread.start();
    }

    public void kill() {
        this.killed = true;
    }

    public void addSegmentToSendQueue(String[] sgmt, long pclock) {
        SegmentSendDescriptor sdesc = new SegmentSendDescriptor(sgmt, pclock);
        this.sgmtQ.sqPut(sdesc);
        ++this.countSegmentsQueued;
    }

    public void addStarterToQueue() {
        this.addSegmentToSendQueue(STARTER_SEGMENT, -200L);
    }

    public void addTerminatorToQueue(long tclk) {
        this.addSegmentToSendQueue(SiGMLSegmentTransmitter.terminatorSeg(tclk), tclk);
        this.doneAddTerminatorToQueue = true;
    }

    public boolean doneSegmentSequenceSend() {
        return this.doneAddTerminatorToQueue && this.countSegmentsSent == this.countSegmentsQueued;
    }

    protected void runSender() {
        SegmentSendDescriptor nxtsgmt = null;
        boolean sgmtready = false;
        int nidle = 0;
        while (!this.killed) {
            if (nxtsgmt == null && this.sgmtQ.sqLength() != 0) {
                nxtsgmt = this.sgmtQ.sqGet();
            }
            if (nxtsgmt != null && !sgmtready && nxtsgmt.transmitStartClock() <= this.timer.clock) {
                nxtsgmt.insertSeqNos(this.seqNoGen);
                sgmtready = true;
            }
            if (sgmtready) {
                String msgbase = "####  XMIT -- sending segment ";
                int iseg = this.countSegmentsSent++;
                int npkts = nxtsgmt.pktCount();
                String msgpkts = "(pkt-count=" + npkts + ")";
                System.out.println(msgbase + iseg + "  " + msgpkts);
                this.sendPackets(nxtsgmt);
                sgmtready = false;
                nxtsgmt = null;
                continue;
            }
            int sn = this.seqNoGen.next();
            String idlepkt = PacketHeader.newSingletonHeader(sn) + "\r\n";
            this.sendOnePacket(idlepkt);
            this.timer.delayTicks(4L);
            ++nidle;
        }
    }

    protected void sendPackets(SegmentSendDescriptor sgmt) {
        int N = sgmt.pktCount();
        for (int i = 0; i != N && !this.killed; ++i) {
            String pkttxt = sgmt.packet(i);
            float pktlen = pkttxt.length();
            this.sendOnePacket(pkttxt);
            this.timer.delay(Math.round(pktlen / 12.0f));
        }
    }

    protected void sendOnePacket(String pkttxt) {
        try {
            this.pktSender.sendPacket(pkttxt);
        }
        catch (PacketSendException psx) {
            String msg = "BPS send exception: " + psx.getMessage();
            System.out.println(msg);
        }
    }

    protected static String[] terminatorSeg(long tclk) {
        String[] termseg = new String[]{TERMINATOR_SEGMENT[0] + " " + tclk};
        return termseg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SegmentQueue
    extends LinkedList<SegmentSendDescriptor> {
        public synchronized void sqPut(SegmentSendDescriptor sdesc) {
            this.addLast(sdesc);
        }

        public synchronized SegmentSendDescriptor sqGet() {
            return (SegmentSendDescriptor)this.removeFirst();
        }

        public synchronized int sqLength() {
            return this.size();
        }
    }
}

