/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.BPSReceiver;
import broadcast.BroadcastSiGMLDefs;
import broadcast.Killable;
import broadcast.SegmentAcceptor;
import broadcast.SeqNumberGenerator;
import broadcast.SiGMLSegmentReceiver;
import broadcast.SiGMLSegmentSynchAcceptor;
import broadcast.SiGMLStreamHandler;
import broadcast.TimeKeeper;
import broadcast.TimerDisplay;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import util.Logging;

public class SiGMLSegmentSynchDelivery
implements SegmentAcceptor,
Killable {
    private static final String TD_TITLE = "SiGML-Receiver Clock";
    private static final long RCV_LEAD_MILLIS = 200L;
    protected static final String SIGML_SECTION_TAG = "sigmlsection";
    private static final InetAddress LOCALHOST;
    protected Logging logger;
    protected TimeKeeper timer;
    protected BPSReceiver pktSource;
    protected SiGMLSegmentReceiver sgmtSource;
    protected SiGMLSegmentSynchAcceptor sgmtTarget;
    protected boolean terminated;
    protected boolean killed;

    public SiGMLSegmentSynchDelivery(SiGMLSegmentSynchAcceptor sssa, Logging lggr) {
        this(sssa, lggr, -1);
    }

    public SiGMLSegmentSynchDelivery(SiGMLSegmentSynchAcceptor sssa, Logging lggr, int bsbaseport) {
        this.logger = lggr;
        this.sgmtTarget = sssa;
        this.terminated = false;
        this.killed = false;
        this.sgmtSource = new SiGMLSegmentReceiver(this);
        try {
            int sendport = BroadcastSiGMLDefs.B_SIGML_SEND_PORT(bsbaseport);
            int rcvport = BroadcastSiGMLDefs.B_SIGML_RCV_PORT(bsbaseport);
            this.pktSource = new BPSReceiver(rcvport, sendport, LOCALHOST, this.sgmtSource);
        }
        catch (IOException iox) {
            String pfx = "SiGMLSegmentSynchDelivery ctor: ";
            System.out.println(pfx + iox.getMessage());
            System.exit(1);
        }
    }

    public void acceptErrorReport(String msg) {
        this.sgmtTarget.acceptErrorReport(msg);
    }

    public synchronized void acceptStarter() {
        if (!this.killed) {
            if (this.timer != null) {
                this.acceptErrorReport("Extra start marker received!");
            } else {
                this.makeTimer();
                this.sgmtTarget.setTimer(this.timer);
                this.sgmtTarget.acceptStarter();
            }
        }
    }

    public synchronized void acceptTerminator(long tclk) {
        if (!this.killed) {
            this.checkStarted();
            this.terminated = true;
            if (this.timer.clock < tclk) {
                this.timer.waitUntil(tclk);
            } else {
                this.timer.delayTicks(2L);
            }
            this.doKill();
            this.sgmtTarget.acceptTerminator(tclk);
        }
    }

    public synchronized void acceptSegment(String sgmt) {
        if (!this.killed) {
            this.checkStarted();
            long pclk = SiGMLStreamHandler.presentClockForSection(sgmt);
            if (0L <= pclk) {
                pclk -= 200L;
            }
            this.timer.waitUntil(pclk);
            this.sgmtTarget.acceptSegment(sgmt);
        }
    }

    public synchronized void kill() {
        if (!this.killed && !this.terminated) {
            this.doKill();
        }
    }

    protected void checkStarted() {
        if (this.timer == null) {
            this.acceptErrorReport("No start marker received!");
            this.acceptStarter();
        }
    }

    protected void doKill() {
        this.killed = true;
        this.pktSource.kill();
        if (this.timer != null) {
            this.timer.kill();
        }
        if (!this.terminated) {
            Thread tterm = new Thread(){

                public void run() {
                    SiGMLSegmentSynchDelivery.this.reportKillToTarget();
                }
            };
            tterm.start();
        }
    }

    protected void reportKillToTarget() {
        if (this.timer == null) {
            this.sgmtTarget.acceptStarter();
        }
        this.sgmtTarget.acceptTerminator(0L);
    }

    protected void makeTimer() {
        long initclk = -200L;
        SeqNumberGenerator sngen = this.sgmtSource.getSeqNumberGenerator();
        String tdTitle = "SiGML-Receiver Clock " + new Date();
        TimerDisplay tdisp = new TimerDisplay(tdTitle, false, sngen);
        this.timer = new TimeKeeper(initclk, tdisp);
    }

    static {
        InetAddress lh = null;
        try {
            lh = InetAddress.getLocalHost();
        }
        catch (IOException iox) {
            String ioxmsg = iox.getMessage();
            String msg = "SiGMLSegmentSynchDelivery static-init: " + ioxmsg;
            System.out.println(msg);
            System.exit(1);
        }
        LOCALHOST = lh;
    }
}

