/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.BroadcastSiGMLDefs;
import broadcast.PacketAcceptor;
import broadcast.PacketHeader;
import broadcast.SegmentAcceptor;
import broadcast.SeqNumberGenerator;

public class SiGMLSegmentReceiver
implements PacketAcceptor {
    private static final int SEQ_NO_LIMIT = 100000000;
    protected final SegmentAcceptor target;
    protected final SeqNumberGenerator seqNoGen;
    protected StringBuilder segmentBuf;
    protected boolean segmentIsInProgress;
    protected int countPktsInSeg;
    protected int countPktsAccepted;
    protected int seqNoExpected;
    protected int idlePktCount;
    protected transient boolean pktIsStale;
    protected transient boolean pktIsPremature;
    protected transient boolean pktCausesSegDrop;

    public SiGMLSegmentReceiver(SegmentAcceptor sa) {
        this.target = sa;
        this.seqNoGen = new SeqNumberGenerator(100000000);
        this.seqNoExpected = this.seqNoGen.next();
        this.segmentIsInProgress = false;
        this.idlePktCount = 0;
    }

    public SeqNumberGenerator getSeqNumberGenerator() {
        return this.seqNoGen;
    }

    public void acceptPacket(String pkt) {
        int n = pkt.indexOf("\r\n");
        if (n < 0) {
            String msg = "Bad packet: missing header line.";
            this.reportErrorToTarget(msg);
        } else {
            String hdrtext = pkt.substring(0, n);
            String pkttext = pkt.substring(n + 2);
            PacketHeader pkthdr = null;
            try {
                pkthdr = PacketHeader.newStringHeader(hdrtext);
            }
            catch (PacketHeader.PktHdrException phx) {
                String msg = "Bad packet header: " + phx.getMessage();
                this.reportErrorToTarget(msg);
            }
            if (pkthdr != null) {
                this.handlePacket(pkthdr, pkttext);
            }
        }
    }

    public void acceptErrorReport(String msg) {
        this.reportErrorToTarget(msg);
    }

    protected void handlePacket(PacketHeader hdr, String pkttext) {
        boolean isIdlePkt = pkttext.length() == 0;
        this.checkPacketHeader(hdr, isIdlePkt);
        if (!this.pktIsStale) {
            if (this.pktCausesSegDrop) {
                this.disposeCurrentSegment();
            }
            if (this.pktIsPremature) {
                this.seqNoGen.resetCurrent(hdr.seqNo());
            }
            if (isIdlePkt) {
                ++this.idlePktCount;
                this.seqNoExpected = this.seqNoGen.next();
            } else if (hdr.isFirstInSeg()) {
                this.startNewSegment(hdr, pkttext);
            } else if (!this.pktIsPremature) {
                this.addPacket(pkttext);
            }
        }
    }

    protected void checkPacketHeader(PacketHeader hdr, boolean isIdlePkt) {
        String msghdr;
        String msg;
        int snactual = hdr.seqNo();
        boolean isfirst = hdr.isFirstInSeg();
        this.pktIsStale = snactual < this.seqNoExpected;
        this.pktIsPremature = this.seqNoExpected < snactual;
        this.pktCausesSegDrop = false;
        if (isIdlePkt && (!isfirst || hdr.packetCount() != 1)) {
            msg = "Bad idle packet -- seq-no=" + snactual;
            this.reportErrorToTarget(msg);
        }
        if (this.pktIsStale) {
            msghdr = "Packet sequence no. is stale:";
            this.reportPktSeqError(msghdr, snactual);
        } else if (this.pktIsPremature) {
            msghdr = "Packet sequence no. is premature:";
            this.reportPktSeqError(msghdr, snactual);
            if (this.segmentIsInProgress) {
                this.pktCausesSegDrop = true;
                this.reportErrorToTarget("Segment dropped.");
            }
        } else if (!isIdlePkt && isfirst == this.segmentIsInProgress) {
            if (isfirst) {
                this.pktCausesSegDrop = true;
                msg = "Unexpected segment start: old segment dropped.";
                this.reportErrorToTarget(msg);
            } else {
                msg = "Packet dropped: seq-no=" + snactual;
                this.reportErrorToTarget(msg);
            }
        }
    }

    protected void disposeCurrentSegment() {
        this.segmentBuf.setLength(0);
        this.segmentBuf = null;
        this.segmentIsInProgress = false;
    }

    protected void startNewSegment(PacketHeader hdr, String pkttext) {
        this.segmentIsInProgress = true;
        this.countPktsInSeg = hdr.packetCount();
        this.countPktsAccepted = 0;
        int segmax = this.countPktsInSeg * 4096;
        this.segmentBuf = new StringBuilder(segmax);
        this.addPacket(pkttext);
    }

    protected void addPacket(String pkttext) {
        this.segmentBuf.append(pkttext);
        this.seqNoExpected = this.seqNoGen.next();
        ++this.countPktsAccepted;
        if (this.countPktsAccepted == this.countPktsInSeg) {
            this.idlePktCount = 0;
            String sgmttext = this.segmentBuf.toString();
            if (SiGMLSegmentReceiver.isStarter(sgmttext)) {
                this.target.acceptStarter();
            } else if (SiGMLSegmentReceiver.isTerminator(sgmttext)) {
                this.target.acceptTerminator(SiGMLSegmentReceiver.terminatorClock(sgmttext));
            } else {
                this.target.acceptSegment(sgmttext);
            }
            this.disposeCurrentSegment();
        }
    }

    protected void reportPktSeqError(String msghdr, int sn) {
        StringBuilder msgbuf = new StringBuilder(128);
        msgbuf.append(msghdr);
        msgbuf.append(" expected=").append(this.seqNoExpected);
        msgbuf.append(" actual=").append(sn).append('.');
        this.reportErrorToTarget(msgbuf.toString());
    }

    protected void reportErrorToTarget(String msg) {
        this.target.acceptErrorReport(msg);
    }

    protected static boolean isStarter(String sgmt) {
        int i = sgmt.indexOf("\r\n");
        String sstr = BroadcastSiGMLDefs.STARTER_SEGMENT[0];
        return i < 0 ? false : sgmt.substring(0, i).trim().equals(sstr);
    }

    protected static boolean isTerminator(String sgmt) {
        int i = sgmt.indexOf("\r\n");
        String tstr = BroadcastSiGMLDefs.TERMINATOR_SEGMENT[0];
        return i < 0 ? false : sgmt.substring(0, i).trim().startsWith(tstr);
    }

    protected static long terminatorClock(String tsgmt) {
        long tclk = 0L;
        String[] toks = tsgmt.trim().split("\\s+");
        if (2 <= toks.length) {
            try {
                tclk = Long.parseLong(toks[1]);
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
        }
        return tclk;
    }
}

