/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.PacketHeader;
import broadcast.SeqNumberGenerator;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentSendDescriptor {
    private static final int PACKET_MAX = 4096;
    private static final int MAX_BYTES_PER_MS = 12;
    private static final long TICKS_PER_FRAME = 4L;
    protected PacketDescriptor[] pktDescs;
    protected long presentClock;
    protected long xmitClock;

    public SegmentSendDescriptor(String[] sgmt, long pclock) {
        this.presentClock = pclock;
        this.pktDescs = this.makePktDescriptors(sgmt);
        long xmittime = 1 + this.xmitLength() / 12;
        long xmitxtra = 12L;
        this.xmitClock = this.presentClock - xmittime - xmitxtra;
    }

    public void insertSeqNos(SeqNumberGenerator sngen) {
        int N = this.pktDescs.length;
        for (int i = 0; i != N; ++i) {
            int sn = sngen.next();
            this.pktDescs[i].setPacketSeqNo(sn);
        }
    }

    public long transmitStartClock() {
        return this.xmitClock;
    }

    public int pktCount() {
        return this.pktDescs.length;
    }

    public String packet(int i) {
        return this.pktDescs[i].packetText();
    }

    protected PacketDescriptor[] makePktDescriptors(String[] slines) {
        int N = slines.length;
        ArrayList<PacketDescriptor> pdal = new ArrayList<PacketDescriptor>(1 + N / 160);
        int i = 0;
        int ibase = 0;
        int sz = 0;
        while (i != N) {
            int inc = slines[i].length() + 2;
            if (i == ibase) {
                inc += 80;
            }
            if (sz + inc < 4096) {
                sz += inc;
                ++i;
                continue;
            }
            this.addPktDescriptor(pdal, slines, ibase, i, sz);
            ibase = i;
            sz = 0;
        }
        if (ibase != N) {
            this.addPktDescriptor(pdal, slines, ibase, N, sz);
        }
        PacketDescriptor[] pdescs = pdal.toArray(new PacketDescriptor[0]);
        pdescs[0].setInitialHeader(0, pdescs.length);
        return pdescs;
    }

    protected void addPktDescriptor(ArrayList<PacketDescriptor> pdal, String[] slines, int lo, int hi, int sz) {
        PacketDescriptor pdesc = new PacketDescriptor(slines, lo, hi, sz);
        if (0 < lo) {
            pdesc.setContinuationHeader(0);
        }
        pdal.add(pdesc);
    }

    protected int xmitLength() {
        int N = this.pktDescs.length;
        int len = 0;
        for (int i = 0; i != N; ++i) {
            len += this.pktDescs[i].packetLength();
        }
        return len;
    }

    protected static class PacketDescriptor {
        protected PacketHeader header;
        protected String[] segment;
        protected int start;
        protected int limit;
        protected int size;

        public PacketDescriptor(String[] sgmt, int strt, int lmt, int sz) {
            this.segment = sgmt;
            this.start = strt;
            this.limit = lmt;
            this.size = sz;
        }

        public void setInitialHeader(int seqno, int cntpkts) {
            this.header = PacketHeader.newStartingHeader(seqno, cntpkts);
        }

        public void setContinuationHeader(int seqno) {
            this.header = PacketHeader.newContinuationHeader(seqno);
        }

        public void setPacketSeqNo(int sn) {
            this.header.setSeqNo(sn);
        }

        public PacketHeader packetHeader() {
            return this.header;
        }

        public String packetText() {
            StringBuilder pktbuf = new StringBuilder(4096);
            pktbuf.append(this.header.toString()).append("\r\n");
            for (int i = this.start; i != this.limit; ++i) {
                pktbuf.append(this.segment[i]).append("\r\n");
            }
            return pktbuf.toString();
        }

        public int packetLength() {
            int n = this.header.toString().length() + 2;
            for (int i = this.start; i != this.limit; ++i) {
                n += this.segment[i].length() + 2;
            }
            return n;
        }
    }
}

