/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import util.RE;

public class PacketHeader {
    public static final int MAX_HDR_SIZE = 80;
    public static final int SEQ_NO_SIZE = 8;
    public static final String COUNT_NAME = "packetCount";
    public static final String CONTINUES_NAME = "packetIsContinuation";
    public static final String COUNT_LC = "packetCount".toLowerCase();
    public static final String CONTINUES_LC = "packetIsContinuation".toLowerCase();
    protected int pktSeqNo;
    protected boolean pktIsFirstInSeg;
    protected int pktCountForSeg;

    public static PacketHeader newSingletonHeader(int seqno) {
        return new PacketHeader(seqno, true, 1);
    }

    public static PacketHeader newStartingHeader(int seqno, int count) {
        return new PacketHeader(seqno, true, count);
    }

    public static PacketHeader newContinuationHeader(int seqno) {
        return new PacketHeader(seqno, false, -1);
    }

    public static PacketHeader newStringHeader(String hdrtxt) throws PktHdrException {
        return new PacketHeader(hdrtxt);
    }

    public void setSeqNo(int sn) {
        this.pktSeqNo = sn;
    }

    public int seqNo() {
        return this.pktSeqNo;
    }

    public boolean isFirstInSeg() {
        return this.pktIsFirstInSeg;
    }

    public int packetCount() {
        return this.pktCountForSeg;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder(80);
        String seqno = this.seqNoString();
        sbuf.append("##  ").append(seqno).append("  ");
        if (this.pktIsFirstInSeg) {
            if (this.pktCountForSeg != 1) {
                String pktcount = String.valueOf(this.pktCountForSeg);
                sbuf.append(COUNT_NAME);
                sbuf.append("=\"").append(pktcount).append("\"  ");
            }
        } else {
            sbuf.append(CONTINUES_NAME).append("=\"true\"  ");
        }
        sbuf.append("##");
        return sbuf.toString();
    }

    protected PacketHeader(int seqno, boolean isfirst, int pcount) {
        this.pktSeqNo = seqno;
        this.pktIsFirstInSeg = isfirst;
        this.pktCountForSeg = pcount;
    }

    protected PacketHeader(String hdrtext) throws PktHdrException {
        String reSeqNo = RE.num(8);
        String reAVItem = RE.SPACE + RE.reAV(RE.WORD);
        String reContent = reSeqNo + RE.seqtag(reAVItem);
        String reHeader = "##" + RE.SPACE + RE.tag(reContent) + RE.SPACE + "##";
        String content = RE.extract(reHeader, hdrtext.toLowerCase());
        String seqNo = RE.extractHead(reSeqNo, content);
        String attrs = RE.extractTail(reSeqNo, content);
        this.pktSeqNo = Integer.parseInt(seqNo, 10);
        this.setIsFirst(attrs);
        this.setPktCount(attrs);
    }

    protected void setIsFirst(String attrs) throws PktHdrException {
        this.pktIsFirstInSeg = true;
        RE.AV avContinues = RE.findAVq(attrs, CONTINUES_LC, RE.STRING);
        if (avContinues != null) {
            if (!avContinues.val.matches(RE.BOOL)) {
                String msg = avContinues.attr + ": value is not boolean.";
                throw new PktHdrException(msg);
            }
            this.pktIsFirstInSeg = avContinues.val.equalsIgnoreCase("false");
        }
    }

    protected void setPktCount(String attrs) throws PktHdrException {
        this.pktCountForSeg = this.pktIsFirstInSeg ? 1 : -1;
        RE.AV avPktCount = RE.findAVq(attrs, COUNT_LC, RE.STRING);
        if (avPktCount != null) {
            if (!avPktCount.val.matches(RE.NON_NEG_INT)) {
                String msg = avPktCount.attr + " value is not integer.";
                throw new PktHdrException(msg);
            }
            if (this.pktIsFirstInSeg) {
                try {
                    this.pktCountForSeg = Integer.parseInt(avPktCount.val, 10);
                }
                catch (NumberFormatException nfx) {
                    throw new PktHdrException(nfx);
                }
            }
        }
    }

    protected String seqNoString() {
        String sn = String.valueOf(this.pktSeqNo);
        int nzeros = 8 - sn.length();
        StringBuilder snbuf = new StringBuilder(8);
        for (int i = 0; i != nzeros; ++i) {
            snbuf.append('0');
        }
        snbuf.append(sn);
        return snbuf.toString();
    }

    public class PktHdrException
    extends Exception {
        public PktHdrException(String msg) {
            super(msg);
        }

        public PktHdrException(Exception x) {
            super(x);
        }
    }
}

