/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.BroadcastSiGMLDefs;
import broadcast.PacketSendException;
import broadcast.PacketSender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class BPSTransmitter
implements PacketSender {
    public static final int PACKET_MAX = 4096;
    protected int senderPort;
    protected DatagramSocket senderSocket;
    protected int receiverPort;
    protected InetAddress receiverHost;
    protected SocketAddress receiverAddress;
    protected boolean killed;

    public BPSTransmitter(int sndrport, int rcvrport, InetAddress rcvrhost) throws UnknownHostException, SocketException {
        this.senderPort = sndrport;
        this.receiverPort = rcvrport;
        this.receiverHost = rcvrhost;
        this.receiverAddress = new InetSocketAddress(this.receiverHost, this.receiverPort);
        this.killed = false;
        this.senderSocket = new DatagramSocket(this.senderPort, InetAddress.getLocalHost());
        this.senderSocket.connect(this.receiverAddress);
    }

    public BPSTransmitter(int sndrport, int rcvrport) throws UnknownHostException, SocketException {
        this(sndrport, rcvrport, InetAddress.getLocalHost());
    }

    public BPSTransmitter(int bsportbase) throws UnknownHostException, SocketException {
        this(BroadcastSiGMLDefs.B_SIGML_SEND_PORT(bsportbase), BroadcastSiGMLDefs.B_SIGML_RCV_PORT(bsportbase));
    }

    public BPSTransmitter() throws UnknownHostException, SocketException {
        this(-1);
    }

    public synchronized void kill() {
        this.killed = true;
        this.senderSocket.disconnect();
        this.senderSocket.close();
    }

    public synchronized void sendPacket(String pkt) throws PacketSendException {
        int N = pkt.length();
        if (4096 < N) {
            String msg = "BPSTransmitter packet too long: " + N;
            throw new PacketSendException(msg);
        }
        try {
            byte[] sndbuf = pkt.getBytes("ISO-8859-1");
            DatagramPacket dpkt = new DatagramPacket(sndbuf, N, this.receiverAddress);
            this.senderSocket.send(dpkt);
        }
        catch (IOException iox) {
            String prefix = "BPSTransmitter send error: ";
            throw new PacketSendException(prefix + iox.getMessage());
        }
    }
}

