/*
 * Decompiled with CFR 0.152.
 */
package broadcast;

import broadcast.PacketAcceptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class BPSReceiver {
    public static final int PACKET_MAX = 4096;
    protected int receiverPort;
    protected DatagramSocket receiverSocket;
    protected int senderPort;
    protected InetAddress senderHost;
    protected PacketAcceptor target;
    protected Thread receiverThread;
    protected boolean killed;

    public BPSReceiver(int rcvrport, int sndrport, InetAddress sndrhost, PacketAcceptor pa) throws UnknownHostException, SocketException {
        this.receiverPort = rcvrport;
        this.senderPort = sndrport;
        this.senderHost = sndrhost;
        this.target = pa;
        this.killed = false;
        this.receiverSocket = new DatagramSocket(this.receiverPort, InetAddress.getLocalHost());
        this.receiverSocket.connect(this.senderHost, this.senderPort);
        this.receiverThread = new Thread(){

            public void run() {
                BPSReceiver.this.runReceiver();
            }
        };
        this.receiverThread.start();
    }

    public BPSReceiver(int rcvrport, int sndrport, PacketAcceptor pa) throws UnknownHostException, SocketException {
        this(rcvrport, sndrport, InetAddress.getLocalHost(), pa);
    }

    public void kill() {
        this.killed = true;
        this.receiverSocket.close();
    }

    protected void runReceiver() {
        byte[] rcvbuf = new byte[4096];
        DatagramPacket rcvpkt = new DatagramPacket(rcvbuf, 4096);
        while (!this.killed) {
            String msg;
            try {
                this.receiverSocket.receive(rcvpkt);
                int N = rcvpkt.getLength();
                String pkt = new String(rcvbuf, 0, N, "ISO-8859-1");
                this.target.acceptPacket(pkt);
            }
            catch (UnsupportedEncodingException uex) {
                msg = "BPSReceiver: " + uex.getMessage();
                this.target.acceptErrorReport(msg);
            }
            catch (IOException iox) {
                msg = "BPSReceiver: " + iox.getMessage();
            }
        }
    }
}

