/*
 * Decompiled with CFR 0.152.
 */
package hamucstable;

import hamucstable.HamUCSMapper;
import hamucstable.HamUCSTableApp;

public class HamUCSTableModel
extends HamUCSTableApp.HamUCSAbstractTableModel {
    public static final int COL_U_97 = 0;
    public static final int COL_U_01 = -1;
    public static final int COL_UCS = 1;
    public static final int COL_H_97 = -1;
    public static final int COL_HNS = 2;
    public static final int COL_OCT = 3;
    private static final String[] COL_NAMES = new String[]{"UCS-1997", "UCS", "HNS-UCS-Ch", "Octet", "HNS-Name"};
    private static final int[] COL_WIDTHS = new int[]{64, 64, 78, 36, 160};
    private static final int N_COLUMNS = COL_NAMES.length;
    private final Object[][] T_DATA = new Object[256][N_COLUMNS];

    public HamUCSTableModel(HamUCSMapper humap) {
        this.populateTable(humap);
    }

    protected void populateTable(HamUCSMapper humap) {
        for (int h = 0; h != 256; ++h) {
            Object[] T_ROW_H = this.T_DATA[h];
            char U_97_CH = humap.ham1997FontChar(h);
            char U_01_CH = humap.ham2001FontChar(h);
            char U_CH = humap.hamUCSFontChar(h);
            T_ROW_H[0] = new HamUCSTableApp.UCSCharacterLabel(U_97_CH);
            T_ROW_H[1] = new HamUCSTableApp.UCSCharacterLabel(U_CH);
            T_ROW_H[2] = new HamUCSTableApp.HNSCharacter(U_CH);
            T_ROW_H[3] = new Integer(h);
            T_ROW_H[4] = humap.hamName(h, "   [ NONE ]");
        }
    }

    public int[] getWidths() {
        return COL_WIDTHS;
    }

    public int getColumnCount() {
        return N_COLUMNS;
    }

    public int getRowCount() {
        return 256;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        return this.T_DATA[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }
}

