/*
 * Decompiled with CFR 0.152.
 */
package hamucstable;

import hamucstable.HamUCSCellRenderer;
import hamucstable.HamUCSMapper;
import hamucstable.HamUCSTableGUI;
import hamucstable.HamUCSTableModel;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class HamUCSTableApp {
    public static final String APP_LABEL = "HamNoSys Symbol Display";
    private final HamUCSMapper HAM_UCS_MAPPER;
    private final HNSCellDefinedChecker CELL_DEF_CHECKER = new HNSCellDefinedChecker(){

        public boolean isUndefined(int row, int col) {
            HamUCSMapper HUMPPR = HamUCSTableApp.this.HAM_UCS_MAPPER;
            char hch = HUMPPR.hamUCSFontChar(row);
            char h97ch = HUMPPR.ham1997FontChar(row);
            char h01ch = HUMPPR.ham2001FontChar(row);
            return 0 == col || 3 == col ? h97ch == '\uffff' : (1 == col ? h01ch == '\uffff' : hch == '\uffff');
        }
    };

    public static void main(String[] args) {
        System.out.println(APP_LABEL);
        HamUCSTableApp hutapp = new HamUCSTableApp();
    }

    public HamUCSTableApp() {
        this.HAM_UCS_MAPPER = new HamUCSMapper();
        JTable hutable = this.makeHUTable();
        HamUCSTableGUI hutgui = new HamUCSTableGUI(hutable);
    }

    private JTable makeHUTable() {
        HamUCSTableModel tm = new HamUCSTableModel(this.HAM_UCS_MAPPER);
        int[] twidths = ((HamUCSAbstractTableModel)tm).getWidths();
        int N_COL = twidths.length;
        JTable t = new JTable(tm);
        int w = 0;
        for (int i = 0; i != N_COL; ++i) {
            TableColumn col = t.getColumn(t.getColumnName(i));
            col.setPreferredWidth(twidths[i]);
            w += twidths[i];
        }
        Font ssfont = new Font("SansSerif", 0, 12);
        Font monofont = new Font("Monospaced", 0, 14);
        t.getColumn(((AbstractTableModel)tm).getColumnName(N_COL - 2)).setCellRenderer(this.makeHUCellRenderer(ssfont));
        t.getColumn(((AbstractTableModel)tm).getColumnName(N_COL - 1)).setCellRenderer(this.makeHUCellRenderer(ssfont));
        t.setDefaultRenderer(HNSCharacter.class, this.makeHUCellRenderer(this.HAM_UCS_MAPPER.hamUCSFont()));
        t.setDefaultRenderer(UCSCharacterLabel.class, this.makeHUCellRenderer(monofont));
        t.setDefaultRenderer(HNS1997Char.class, this.makeHUCellRenderer(this.HAM_UCS_MAPPER.ham1997Font()));
        t.setDefaultRenderer(HNS2001Char.class, this.makeHUCellRenderer(this.HAM_UCS_MAPPER.ham2001Font()));
        t.setPreferredScrollableViewportSize(new Dimension(w, 544));
        t.setRowHeight(32);
        return t;
    }

    private HamUCSCellRenderer makeHUCellRenderer(Font font) {
        return new HamUCSCellRenderer(font, this.CELL_DEF_CHECKER);
    }

    public static abstract class HamUCSAbstractTableModel
    extends AbstractTableModel {
        public abstract int[] getWidths();
    }

    public static interface HNSCellDefinedChecker {
        public boolean isUndefined(int var1, int var2);
    }

    public static class HNS2001Char {
        private final char HNS_2001_CHAR;

        public HNS2001Char(char h01ch) {
            this.HNS_2001_CHAR = h01ch;
        }

        public String toString() {
            return "  " + this.HNS_2001_CHAR;
        }
    }

    public static class HNS1997Char {
        private final char HNS_1997_CHAR;

        public HNS1997Char(char h97ch) {
            this.HNS_1997_CHAR = h97ch;
        }

        public String toString() {
            return "  " + this.HNS_1997_CHAR;
        }
    }

    public static class HNSCharacter {
        private final char HNS_CHAR;

        public HNSCharacter(char hc) {
            this.HNS_CHAR = hc;
        }

        public String toString() {
            return "  " + this.HNS_CHAR;
        }
    }

    public static class UCSCharacterLabel {
        private final char U_CH;

        public UCSCharacterLabel(char ch) {
            this.U_CH = ch;
        }

        public String toString() {
            return String.format(" U+%04X", 0xFFFF & this.U_CH);
        }
    }
}

