/*
 * Decompiled with CFR 0.152.
 */
package hamucstable;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class HamUCSMapper {
    public static final int HAM_ID_LIMIT = 256;
    public static final char UCS_UNDEFINED = '\uffff';
    public static final char H8_UNDEFINED = '\u0000';
    private static final String UNUSED_TAG = "UNUSED";
    public static final float HAM_FONT_SIZE = 32.0f;
    private static final String HAM_TT_1997_NAME = "HAM-1997";
    private static final String HAM_TT_2001_NAME = "Ham-2001";
    private static final String HAM_UCS_NAME = "HamNoSysUnicode";
    private static final String HAM_SYMBOLS_NAME = "HamSymbols";
    private static final String HAM_SYMBOLS_ADJ_NAME = "HamSymbols-adjust";
    private static final String HAM_2001_ADJ_NAME = "HamOctet-2001-adjust";
    private char[] hamUCS;
    private String[] hamName;
    private HashMap<String, Integer> hamID;
    private char[] ham1997UCS;
    private char[] ham2001UCS;
    private Font hamUCSFont;
    private Font ham1997Font = this.loadHamFont("HAM-1997");
    private Font ham2001Font;

    public static void main(String[] args) {
        HamUCSMapper humapper = new HamUCSMapper();
        humapper.listHamData();
    }

    public HamUCSMapper() {
        this.hamUCSFont = this.loadHamFont(HAM_UCS_NAME);
        this.ham2001Font = this.ham1997Font;
        this.makeHamTables();
        this.updateHamTables(HAM_SYMBOLS_NAME);
        this.updateHamTables(HAM_SYMBOLS_ADJ_NAME);
        this.makeHam1997Table();
        this.makeHam2001Table(HAM_2001_ADJ_NAME);
    }

    public Font ham1997Font() {
        return this.ham1997Font;
    }

    public Font ham2001Font() {
        return this.ham2001Font;
    }

    public Font hamUCSFont() {
        return this.hamUCSFont;
    }

    public int hamCode(String hname) {
        Integer hh = this.hamID.get(hname);
        return hh == null ? -1 : hh;
    }

    public String hamName(int h) {
        return this.hamName(h, null);
    }

    public String hamName(int h, String dflthnm) {
        String hnm = h < 0 || 256 <= h ? null : this.hamName[h];
        return hnm == null ? dflthnm : hnm;
    }

    public char hamUCSFontChar(int h) {
        return h < 0 || 256 <= h ? (char)'\uffff' : this.hamUCS[h];
    }

    public char hamUCSFontChar(String hname) {
        return this.hamUCSFontChar(this.hamCode(hname));
    }

    public char ham1997FontChar(int h, char dflt97) {
        char H97 = h < 0 || 256 <= h ? (char)'\uffff' : this.ham1997UCS[h];
        return H97 == '\uffff' ? dflt97 : H97;
    }

    public char ham1997FontChar(int h) {
        return this.ham1997FontChar(h, '\uffff');
    }

    public char ham2001FontChar(int h, char dflt01) {
        char H01 = h < 0 || 256 <= h ? (char)'\uffff' : this.ham2001UCS[h];
        return H01 == '\uffff' ? dflt01 : H01;
    }

    public char ham2001FontChar(int h) {
        return this.ham2001FontChar(h, '\uffff');
    }

    private void listHamData() {
        int MOVEI_CH = 173;
        String ENCODING = "utf-8";
        String U8PATH = "/Users/re/Desktop/ham-u-8-table-A.txt";
        try {
            FileOutputStream fouts = new FileOutputStream("/Users/re/Desktop/ham-u-8-table-A.txt");
            OutputStreamWriter fwrtr = new OutputStreamWriter((OutputStream)fouts, "utf-8");
            int nerr = 0;
            for (int h = 0; h != 256; ++h) {
                char H01;
                String HAM_NAME = this.hamName[h];
                char HAM_UCS = this.hamUCS[h];
                String fontflag = HAM_UCS == '\uffff' ? "--" : (this.hamUCSFont == null ? "??" : (this.hamUCSFont.canDisplay(HAM_UCS) ? "OK" : "??"));
                char H01_INT = H01 = this.ham2001FontChar(h, '#');
                fwrtr.write(String.format("  %1c    %4x %4d\n", Character.valueOf(H01), (int)H01_INT, (int)H01_INT));
                if (HAM_UCS == this.hamUCSFontChar(HAM_NAME)) continue;
                System.out.println("####  HAM_UCS error: " + h + " " + HAM_NAME + " " + HAM_UCS + " " + this.hamUCSFontChar(HAM_NAME));
                ++nerr;
            }
            ((Writer)fwrtr).flush();
            ((Writer)fwrtr).close();
            if (nerr != 0) {
                System.out.println("UCS error count: " + nerr);
            }
        }
        catch (IOException iox) {
            System.out.println(iox);
        }
    }

    private Font loadHamFont(String hfname) {
        String ERR_MSG_PFX = "####  loadHamFont() " + hfname + ": ";
        Font font = null;
        try {
            InputStream fins = HamUCSMapper.dataStream(hfname, "ttf");
            font = Font.createFont(0, fins).deriveFont(32.0f);
            fins.close();
        }
        catch (FontFormatException fx) {
            System.out.println(ERR_MSG_PFX + fx);
        }
        catch (IOException iox) {
            System.out.println(ERR_MSG_PFX + iox);
        }
        return font;
    }

    private void addToTables(String HH, String PROP) {
        int H = Integer.decode(HH);
        String[] PTOKENS = PROP.split("\\s+");
        String HAM_NAME = PTOKENS[0];
        char HAM_UC = PTOKENS.length == 1 ? (char)H : (char)Integer.decode("0x" + PTOKENS[1]).intValue();
        this.hamName[H] = HAM_NAME;
        this.hamUCS[H] = HAM_UC;
        this.hamID.put(HAM_NAME, H);
    }

    private void makeHamTables() {
        this.hamUCS = new char[256];
        this.hamName = new String[256];
        this.hamID = new HashMap();
        for (int h = 0; h != 256; ++h) {
            this.hamUCS[h] = 65535;
            this.hamName[h] = null;
        }
    }

    private void updateHamTables(String hpname) {
        Properties H_PROPS = HamUCSMapper.getHamProps(hpname, "txt");
        Enumeration<Object> HP_ENUM = H_PROPS.keys();
        while (HP_ENUM.hasMoreElements()) {
            String HH = (String)HP_ENUM.nextElement();
            String PROP = H_PROPS.getProperty(HH).trim();
            if (PROP.equals(UNUSED_TAG)) continue;
            this.addToTables(HH, PROP);
        }
    }

    private void makeHam2001Table(String h2001adj) {
        this.ham2001UCS = new char[256];
        for (int h = 0; h != 256; ++h) {
            char U_CH = this.hamUCS[h];
            this.ham2001UCS[h] = (char)(U_CH == '\uffff' ? 65535 : h);
        }
        Properties H01_PROPS = HamUCSMapper.getHamProps(h2001adj, "txt");
        Set<Object> H01KS = H01_PROPS.keySet();
        Object[] H01_KEYS = H01KS.toArray(new String[H01KS.size()]);
        Arrays.sort(H01_KEYS);
        for (Object H01K : H01_KEYS) {
            String PROP = H01_PROPS.getProperty((String)H01K).trim();
            int H = Integer.decode((String)H01K);
            int HU = PROP.startsWith("#") ? 0 : 0xFFFF & Integer.decode(PROP.split("\\s+")[0]);
            this.ham2001UCS[H] = (char)HU;
        }
    }

    private void makeHam1997Table() {
        int[] EXTRA_OLD_UNDEFS;
        this.ham1997UCS = new char[256];
        boolean[] ham97def = new boolean[256];
        for (int h = 0; h != 256; ++h) {
            ham97def[h] = this.hamUCSFontChar(h) != '\uffff';
        }
        for (int hun : EXTRA_OLD_UNDEFS = new int[]{20, 69, 70, 93, 94, 95, 107, 108, 109, 110, 158, 217, 218, 219, 225, 226, 227, 228, 229, 230, 231, 236, 237}) {
            ham97def[hun] = false;
        }
        ham97def[127] = true;
        for (int h = 0; h != 256; ++h) {
            this.ham1997UCS[h] = ham97def[h] ? (int)(0xF000 | h) : 65535;
        }
    }

    private static Properties getHamProps(String hpbase, String hpsfx) {
        return HamUCSMapper.getHamProps(hpbase + "." + hpsfx);
    }

    private static Properties getHamProps(String hpname) {
        Properties hprops = new Properties();
        InputStream hpins = HamUCSMapper.dataStream(hpname);
        if (hpins != null) {
            try {
                hprops.load(hpins);
            }
            catch (IOException iox) {
                System.out.println("####  Load properties error: " + iox);
            }
        }
        return hprops;
    }

    private static InputStream dataStream(String fbase, String fsfx) {
        return HamUCSMapper.dataStream(fbase + "." + fsfx);
    }

    private static InputStream dataStream(String fname) {
        String path = "data/" + fname;
        InputStream dins = HamUCSMapper.class.getResourceAsStream(path);
        if (dins == null) {
            System.out.println("####  " + fname + ": missing resource file.");
        }
        return dins;
    }
}

